/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.componentfactory.EnhancedRichTextEditor;
import com.vaadin.componentfactory.toolbar.ToolbarSlot;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import java.util.Optional;
import java.util.stream.Stream;

public class SlotUtil {
    public static final String CUSTOM_GROUP_SLOTNAME = ToolbarSlot.GROUP_CUSTOM.getSlotName();

    private static Stream<Element> getElementsInSlot(HasElement target, String slot) {
        return target.getElement().getChildren().filter(child -> slot.equals(child.getAttribute("slot")));
    }

    @Deprecated
    public static void addButton(EnhancedRichTextEditor target, Button component) {
        SlotUtil.addComponent(target, (Component)component);
    }

    public static void addComponent(EnhancedRichTextEditor target, Component component) {
        SlotUtil.addComponent(target, CUSTOM_GROUP_SLOTNAME, component);
    }

    public static void addComponentAtIndex(EnhancedRichTextEditor target, Component component, int index) {
        SlotUtil.addComponentAtIndex(target, CUSTOM_GROUP_SLOTNAME, component, index);
    }

    public static void addComponent(EnhancedRichTextEditor target, String slot, Component component) {
        if (component != null) {
            component.getElement().setAttribute("slot", slot);
            target.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    public static void addComponentAtIndex(EnhancedRichTextEditor target, String slot, Component component, int index) {
        if (component != null) {
            component.getElement().setAttribute("slot", slot);
            target.getElement().insertChild(index, new Element[]{component.getElement()});
        }
    }

    public static void addSuffixIcon(Button button, VaadinIcon icon) {
        Icon i = icon.create();
        SlotUtil.addSuffixIcon(button, (Component)i);
    }

    public static void addSuffixIcon(Button button, Component icon) {
        icon.getElement().setAttribute("slot", "suffix");
        button.getElement().appendChild(new Element[]{icon.getElement()});
        button.addClassName("suffix-icon");
    }

    private static void clearSlot(EnhancedRichTextEditor target, String slot) {
        SlotUtil.getElementsInSlot((HasElement)target, slot).forEach(arg_0 -> SlotUtil.lambda$clearSlot$1(target.getElement(), arg_0));
    }

    private static Stream<Component> getComponentsInSlot(HasElement target, String slot) {
        return SlotUtil.getElementsInSlot(target, slot).map(Element::getComponent).filter(Optional::isPresent).map(Optional::get);
    }

    public static Component getComponent(EnhancedRichTextEditor target, String slot, String id) {
        return SlotUtil.getComponentsInSlot((HasElement)target, slot).filter(component -> id.equals(component.getId().orElse(null))).findFirst().orElse(null);
    }

    public static void removeComponent(EnhancedRichTextEditor target, String slot, String id) {
        Component component = SlotUtil.getComponent(target, slot, id);
        if (component != null) {
            component.getElement().removeFromParent();
        }
    }

    public static void removeComponent(EnhancedRichTextEditor target, String slot, Component component) {
        SlotUtil.getComponentsInSlot((HasElement)target, slot).filter(c -> c.equals(component)).findFirst().map(Component::getElement).ifPresent(Element::removeFromParent);
    }

    public static void removeButton(EnhancedRichTextEditor target, String id) {
        SlotUtil.removeComponent(target, CUSTOM_GROUP_SLOTNAME, id);
    }

    public static void removeButton(EnhancedRichTextEditor target, Button button) {
        SlotUtil.removeComponent(target, CUSTOM_GROUP_SLOTNAME, (Component)button);
    }

    public static Button getButton(EnhancedRichTextEditor target, String id) {
        return (Button)SlotUtil.getComponent(target, CUSTOM_GROUP_SLOTNAME, id);
    }

    public static void replaceStandardButtonIcon(EnhancedRichTextEditor target, Icon icon, String iconSlotName) {
        if (icon != null) {
            SlotUtil.clearSlot(target, iconSlotName);
            icon.getElement().setAttribute("slot", iconSlotName);
            target.getElement().appendChild(new Element[]{icon.getElement()});
        }
    }

    private static /* synthetic */ void lambda$clearSlot$1(Element rec$, Element xva$0) {
        Element cfr_ignored_0 = (Element)rec$.removeChild(new Element[]{xva$0});
    }
}

