/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.componentfactory.EnhancedRichTextEditor;
import com.vaadin.componentfactory.EnhancedRichTextEditorVariant;
import com.vaadin.componentfactory.Placeholder;
import com.vaadin.componentfactory.TabStop;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonFactory;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonArray;
import elemental.json.impl.JreJsonFactory;
import elemental.json.impl.JreJsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vcf-enhanced-rich-text-editor")
@JsModule(value="./src/vcf-enhanced-rich-text-editor.js")
public abstract class GeneratedEnhancedRichTextEditor<R extends GeneratedEnhancedRichTextEditor<R, T>, T>
extends AbstractSinglePropertyField<R, T>
implements HasStyle,
HasTheme,
Focusable<GeneratedEnhancedRichTextEditor<R, T>> {
    public void addThemeVariants(EnhancedRichTextEditorVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(EnhancedRichTextEditorVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(EnhancedRichTextEditorVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(EnhancedRichTextEditorVariant::getVariantName).collect(Collectors.toList()));
    }

    public void setTabStops(List<TabStop> tabStops) {
        JreJsonFactory factory = new JreJsonFactory();
        JreJsonArray arrayTabStops = new JreJsonArray((JsonFactory)factory);
        int index = 0;
        for (TabStop tab : tabStops) {
            JreJsonObject obj = new JreJsonObject((JsonFactory)factory);
            obj.put("direction", tab.getDirection().name().toLowerCase());
            obj.put("position", tab.getPosition());
            arrayTabStops.set(index++, (JsonValue)obj);
        }
        this.getElement().setPropertyJson("tabStops", (JsonValue)arrayTabStops);
    }

    @Synchronize(property="tabStops", value={"tab-stops-changed"})
    public List<TabStop> getTabStops() {
        ArrayList<TabStop> tabStops = new ArrayList<TabStop>();
        JsonArray rawArray = (JsonArray)this.getElement().getPropertyRaw("tabStops");
        this.getElement().addPropertyChangeListener("tabStops", "tabStops-changed", (PropertyChangeListener & Serializable)e -> {});
        this.getElement().addPropertyChangeListener("tabStops", "tab-stops-changed", (PropertyChangeListener & Serializable)e -> {});
        this.getElement().addPropertyChangeListener("tabStops", "change", (PropertyChangeListener & Serializable)e -> {});
        this.getElement().addPropertyChangeListener("tabStops", "value-changed", (PropertyChangeListener & Serializable)e -> {});
        if (rawArray == null) {
            return tabStops;
        }
        for (int i = 0; i < rawArray.length(); ++i) {
            JsonObject obj = rawArray.getObject(i);
            try {
                TabStop tab = new TabStop(TabStop.Direction.valueOf(obj.getString("direction").toUpperCase()), obj.get("position").asNumber());
                tabStops.add(tab);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return tabStops;
    }

    @Synchronize(property="htmlValue", value={"html-value-changed"})
    protected String getHtmlValueString() {
        return this.getElement().getProperty("htmlValue");
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    public void setNoRulers(boolean noRulers) {
        this.getElement().setProperty("noRulers", noRulers);
    }

    protected boolean isReadonlyBoolean() {
        return this.getElement().getProperty("readonly", false);
    }

    protected void setReadonly(boolean readonly) {
        this.getElement().setProperty("readonly", readonly);
    }

    protected JsonArray getI18nJsonArray() {
        return (JsonArray)this.getElement().getPropertyRaw("i18n");
    }

    protected void setI18n(JsonArray i18n) {
        this.getElement().setPropertyJson("i18n", (JsonValue)i18n);
    }

    protected Registration addChangeListener(ComponentEventListener<ChangeEvent<R>> listener) {
        return this.addListener(ChangeEvent.class, listener);
    }

    protected Registration addPlaceholderBeforeRemoveListener(ComponentEventListener<PlaceholderBeforeRemoveEvent<R>> listener) {
        return this.addListener(PlaceholderBeforeRemoveEvent.class, listener);
    }

    protected Registration addPlaceholderBeforeInsertListener(ComponentEventListener<PlaceholderBeforeInsertEvent<R>> listener) {
        return this.addListener(PlaceholderBeforeInsertEvent.class, listener);
    }

    protected Registration addPlaceholderRemovedListener(ComponentEventListener<PlaceholderRemovedEvent<R>> listener) {
        return this.addListener(PlaceholderRemovedEvent.class, listener);
    }

    protected Registration addPlaceholderButtonClickedListener(ComponentEventListener<PlaceholderButtonClickedEvent<R>> listener) {
        return this.addListener(PlaceholderButtonClickedEvent.class, listener);
    }

    protected Registration addPlaceholderInsertedListener(ComponentEventListener<PlaceholderInsertedEvent<R>> listener) {
        return this.addListener(PlaceholderInsertedEvent.class, listener);
    }

    protected Registration addPlaceholderSelectedListener(ComponentEventListener<PlaceholderSelectedEvent<R>> listener) {
        return this.addListener(PlaceholderSelectedEvent.class, listener);
    }

    protected Registration addPlaceholderLeaveListener(ComponentEventListener<PlaceholderLeaveEvent<R>> listener) {
        return this.addListener(PlaceholderLeaveEvent.class, listener);
    }

    protected Registration addPlaceholderAppearanceChangedListener(ComponentEventListener<PlaceholderAppearanceChangedEvent<R>> listener) {
        return this.addListener(PlaceholderAppearanceChangedEvent.class, listener);
    }

    public <P> GeneratedEnhancedRichTextEditor(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedEnhancedRichTextEditor(T initialValue, T defaultValue, boolean acceptNullValues) {
        super("value", defaultValue, acceptNullValues);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedEnhancedRichTextEditor(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedEnhancedRichTextEditor() {
        this(null, null, null, (SerializableFunction)null, (SerializableFunction)null);
    }

    public void focus() {
        Element element = this.getElement();
        element.executeJs("setTimeout(function(){$0._editor.focus()},0)", new Serializable[]{element});
    }

    @DomEvent(value="change")
    public static class ChangeEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends ComponentEvent<R> {
        public ChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="placeholder-before-delete")
    public static class PlaceholderBeforeRemoveEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends AbstractMultiPlaceholderEvent<R> {
        public PlaceholderBeforeRemoveEvent(R source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored, @EventData(value="event.detail") JsonObject detail) {
            super(source, fromClient, detail.getArray("placeholders"));
        }

        public void remove() {
            EnhancedRichTextEditor s = (EnhancedRichTextEditor)((Object)this.source);
            s.getElement().executeJs("this._confirmRemovePlaceholders()", new Serializable[0]);
        }
    }

    @DomEvent(value="placeholder-before-insert")
    public static class PlaceholderBeforeInsertEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends AbstractMultiPlaceholderEvent<R> {
        public PlaceholderBeforeInsertEvent(R source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored, @EventData(value="event.detail") JsonObject detail) {
            super(source, fromClient, detail.getArray("placeholders"));
        }

        public void insert() {
            EnhancedRichTextEditor s = (EnhancedRichTextEditor)((Object)this.source);
            s.getElement().executeJs("this._confirmInsertPlaceholders()", new Serializable[0]);
        }
    }

    @DomEvent(value="placeholder-delete")
    public static class PlaceholderRemovedEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends AbstractMultiPlaceholderEvent<R> {
        public PlaceholderRemovedEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail) {
            super(source, fromClient, detail.getArray("placeholders"));
        }
    }

    @DomEvent(value="placeholder-button-click")
    public static class PlaceholderButtonClickedEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends ComponentEvent<R> {
        private int position;

        public PlaceholderButtonClickedEvent(R source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored, @EventData(value="event.detail.position") int position) {
            super(source, fromClient);
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }

        public void insert(Placeholder placeholder) {
            this.insert(placeholder, this.position);
        }

        public void insert(Placeholder placeholder, int position) {
            Objects.requireNonNull(placeholder, "Placeholder cannot be null");
            EnhancedRichTextEditor s = (EnhancedRichTextEditor)((Object)this.source);
            s.getElement().executeJs("this._confirmInsertPlaceholders([{$0,index: $1}])", new Serializable[]{placeholder.toJson(), Integer.valueOf(position)});
        }
    }

    @DomEvent(value="placeholder-insert")
    public static class PlaceholderInsertedEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends AbstractMultiPlaceholderEvent<R> {
        public PlaceholderInsertedEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail) {
            super(source, fromClient, detail.getArray("placeholders"));
        }
    }

    @DomEvent(value="placeholder-select")
    public static class PlaceholderSelectedEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends AbstractMultiPlaceholderEvent<R> {
        public PlaceholderSelectedEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail) {
            super(source, fromClient, detail.getArray("placeholders"));
        }
    }

    @DomEvent(value="placeholder-leave")
    public static class PlaceholderLeaveEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends ComponentEvent<R> {
        public PlaceholderLeaveEvent(R source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="placeholder-appearance-change")
    public static class PlaceholderAppearanceChangedEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends ComponentEvent<R> {
        private Boolean altAppearance;
        private String appearanceLabel;

        public PlaceholderAppearanceChangedEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail) {
            super(source, fromClient);
            this.altAppearance = detail.hasKey("altAppearance") ? Boolean.valueOf(detail.getBoolean("altAppearance")) : null;
            this.appearanceLabel = detail.hasKey("appearanceLabel") ? detail.getString("appearanceLabel") : null;
        }

        public Boolean getAltAppearance() {
            return this.altAppearance;
        }

        public String getAppearanceLabel() {
            return this.appearanceLabel;
        }
    }

    public static abstract class AbstractMultiPlaceholderEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends ComponentEvent<R> {
        private List<Placeholder> placeholders = new ArrayList<Placeholder>();

        public AbstractMultiPlaceholderEvent(R source, boolean fromClient, JsonArray placeholderJson) {
            super(source, fromClient);
            if (placeholderJson != null) {
                for (int i = 0; i < placeholderJson.length(); ++i) {
                    JsonObject pHolder = (JsonObject)placeholderJson.get(i);
                    int index = -1;
                    if (pHolder.hasKey("placeholder") && pHolder.hasKey("index")) {
                        double ind = pHolder.getNumber("index");
                        index = (int)ind;
                        pHolder = pHolder.getObject("placeholder");
                    }
                    Placeholder placeholder = new Placeholder(pHolder);
                    if (index != -1) {
                        placeholder.setIndex(index);
                    }
                    this.placeholders.add(placeholder);
                }
            }
        }

        public List<Placeholder> getPlaceholders() {
            if (this.source instanceof EnhancedRichTextEditor) {
                ArrayList<Placeholder> actualPlaceholders = new ArrayList<Placeholder>();
                for (Placeholder placeholder : this.placeholders) {
                    Placeholder actualPlaceholder = ((EnhancedRichTextEditor)((Object)this.source)).getPlaceholder(placeholder);
                    if (placeholder.getIndex() != -1) {
                        actualPlaceholder.setIndex(placeholder.getIndex());
                    }
                    actualPlaceholders.add(actualPlaceholder);
                }
                return actualPlaceholders;
            }
            return null;
        }
    }

    public static abstract class AbstractPlaceholderEvent<R extends GeneratedEnhancedRichTextEditor<R, ?>>
    extends ComponentEvent<R> {
        private Placeholder placeholder;

        public AbstractPlaceholderEvent(R source, boolean fromClient, JsonObject placeholderJson) {
            super(source, fromClient);
            if (placeholderJson != null) {
                this.placeholder = new Placeholder(placeholderJson);
            }
        }

        public Placeholder getPlaceholder() {
            if (this.source instanceof EnhancedRichTextEditor) {
                return ((EnhancedRichTextEditor)((Object)this.source)).getPlaceholder(this.placeholder);
            }
            return null;
        }
    }
}

