/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.componentfactory.GeneratedEnhancedRichTextEditor;
import com.vaadin.componentfactory.Placeholder;
import com.vaadin.componentfactory.SlotUtil;
import com.vaadin.componentfactory.TabConverter;
import com.vaadin.componentfactory.toolbar.ToolbarSlot;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import elemental.json.JsonArray;
import elemental.json.JsonFactory;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonArray;
import elemental.json.impl.JreJsonFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Safelist;

@Tag(value="vcf-enhanced-rich-text-editor")
@JsModule(value="./richTextEditorConnector-npm.js")
@JavaScript(value="./richTextEditorConnector.js")
@NpmPackage(value="@vaadin/vaadin-license-checker", version="^2.1.2")
public class EnhancedRichTextEditor
extends GeneratedEnhancedRichTextEditor<EnhancedRichTextEditor, String>
implements HasSize,
HasValueChangeMode,
InputNotifier,
KeyNotifier,
CompositionNotifier {
    private ValueChangeMode currentMode;
    private RichTextEditorI18n i18n;
    private Map<ToolbarButton, Boolean> toolbarButtonsVisibility;
    private Collection<Placeholder> placeholders;

    public RichTextEditorI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(RichTextEditorI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
                for (String key : i18nObject.keys()) {
                    ui.getPage().executeJs("$0.set('i18n." + key + "', $1)", new Serializable[]{this.getElement(), i18nObject.get(key)});
                }
            }
        });
    }

    public Map<ToolbarButton, Boolean> getToolbarButtonsVisibility() {
        return this.toolbarButtonsVisibility;
    }

    public void setToolbarButtonsVisibility(Map<ToolbarButton, Boolean> toolbarButtonsVisibility) {
        this.toolbarButtonsVisibility = toolbarButtonsVisibility;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            String str = toolbarButtonsVisibility.toString();
            str = str.replaceAll("=", ":");
            ui.getPage().executeJs("setToolbarButtons($0, $1)", new Serializable[]{this.getElement(), str});
        });
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public EnhancedRichTextEditor() {
        super("", "", false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
    }

    public EnhancedRichTextEditor(String initialValue) {
        this();
        this.setValue(initialValue);
    }

    public EnhancedRichTextEditor(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EnhancedRichTextEditor, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public EnhancedRichTextEditor(String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EnhancedRichTextEditor, String>> listener) {
        this();
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
    }

    public void setValue(String value) {
        super.setValue((Object)TabConverter.convertIfNeeded(value));
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public String getHtmlValue() {
        return this.sanitize(this.getHtmlValueString());
    }

    public void setShowWhitespace(boolean show) {
        this.getElement().setProperty("showWhitespace", show);
    }

    public boolean isShowWhitespace() {
        return this.getElement().getProperty("showWhitespace", false);
    }

    String sanitize(String html) {
        String cleaned = Jsoup.clean((String)html, (Safelist)Safelist.basic().addTags(new String[]{"img", "h1", "h2", "h3", "s", "span", "br"}).addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width"}).addAttributes("span", new String[]{"class", "contenteditable"}).addAttributes(":all", new String[]{"style"}).addProtocols("img", "src", new String[]{"data"}));
        Document doc = Jsoup.parse((String)cleaned);
        Set<String> allowedClasses = Set.of("ql-tab", "ql-soft-break", "ql-readonly", "ql-placeholder");
        for (Element span : doc.select("span[class]")) {
            String[] classes = span.attr("class").split("\\s+");
            StringBuilder filtered = new StringBuilder();
            for (String cls : classes) {
                if (!allowedClasses.contains(cls)) continue;
                if (filtered.length() > 0) {
                    filtered.append(' ');
                }
                filtered.append(cls);
            }
            if (filtered.length() > 0) {
                span.attr("class", filtered.toString());
                continue;
            }
            span.removeAttr("class");
        }
        for (Element span : doc.select("span[contenteditable]")) {
            if ("false".equals(span.attr("contenteditable"))) continue;
            span.removeAttr("contenteditable");
        }
        return doc.body().html();
    }

    public void setPlaceholders(Collection<Placeholder> placeholders) {
        Objects.requireNonNull(placeholders, "placeholders cannot be null");
        JreJsonFactory factory = new JreJsonFactory();
        JreJsonArray jsonArray = new JreJsonArray((JsonFactory)factory);
        int index = 0;
        for (Placeholder placeholder : placeholders) {
            jsonArray.set(index++, (JsonValue)placeholder.toJson());
        }
        this.placeholders = placeholders;
        this.getElement().setPropertyJson("placeholders", (JsonValue)jsonArray);
    }

    @Synchronize(property="placeholders", value={"placeholders-changed"})
    public Collection<Placeholder> getPlaceholders() {
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>();
        JsonArray rawArray = (JsonArray)this.getElement().getPropertyRaw("placeholders");
        if (rawArray == null) {
            return placeholders;
        }
        for (int i = 0; i < rawArray.length(); ++i) {
            JsonObject obj = rawArray.getObject(i);
            try {
                Placeholder placeholder = new Placeholder(obj);
                placeholders.add(placeholder);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return placeholders;
    }

    public void setPlaceholderAltAppearancePattern(String pattern) {
        this.getElement().setProperty("placeholderAltAppearancePattern", pattern);
    }

    @Synchronize(property="placeholderAltAppearancePattern", value={"placeholder-alt-appearance-pattern-changed"})
    public String getPlaceholderAltAppearancePattern() {
        return this.getElement().getProperty("placeholderAltAppearancePattern");
    }

    public void setPlacehoderAltAppearance(boolean altAppearance) {
        this.getElement().setProperty("placeholderAltAppearance", altAppearance);
    }

    @Synchronize(property="placeholderAltAppearance", value={"placeholder-alt-appearance-changed"})
    public boolean isPlacehoderAltAppearance() {
        return this.getElement().getProperty("placeholderAltAppearance", false);
    }

    protected Placeholder getPlaceholder(Placeholder placeholder) {
        Objects.requireNonNull(placeholder, "Placeholder cannot be null");
        Objects.requireNonNull(this.placeholders, "getPlaceholder cannot be called before placeholders are set");
        return this.placeholders.stream().filter(p -> p.getText().equals(placeholder.getText())).findFirst().orElse(null);
    }

    public int getTextLength() {
        return Jsoup.clean((String)this.getHtmlValueString(), (Safelist)Safelist.none()).length();
    }

    public void addText(String text, int position) {
        Objects.requireNonNull(text, "Text can't be null");
        this.getHtmlValue();
        if (position >= 0 && position <= this.getTextLength()) {
            this.getElement().executeJs("$0._editor.insertText($1,$2)", new Serializable[]{this.getElement(), Integer.valueOf(position), text});
        }
    }

    public void addText(String text) {
        Objects.requireNonNull(text, "Text can't be null");
        this.getElement().executeJs("if ($0._editor.getSelection()) $0._editor.insertText($0._editor.getSelection().index,$1)", new Serializable[]{this.getElement(), text});
    }

    @Deprecated
    public void addCustomButton(Button button) {
        Objects.requireNonNull(button, "Button can't be null");
        this.addCustomToolbarComponents(new Component[]{button});
    }

    @Deprecated
    public void addCustomButtons(Button ... buttons) {
        this.addCustomToolbarComponents((Component[])buttons);
    }

    public void addCustomToolbarComponents(Component ... components) {
        this.addToolbarComponents(ToolbarSlot.GROUP_CUSTOM, components);
    }

    public void addCustomToolbarComponentsAtIndex(int index, Component ... components) {
        this.addToolbarComponentsAtIndex(ToolbarSlot.GROUP_CUSTOM, index, components);
    }

    public void addToolbarComponents(ToolbarSlot toolbarSlot, Component ... components) {
        Objects.requireNonNull(components);
        for (Component component : components) {
            Objects.requireNonNull(component);
            SlotUtil.addComponent(this, toolbarSlot.getSlotName(), component);
        }
    }

    public void addToolbarComponentsAtIndex(ToolbarSlot toolbarSlot, int index, Component ... components) {
        Objects.requireNonNull(components);
        for (Component component : components) {
            Objects.requireNonNull(component);
            SlotUtil.addComponentAtIndex(this, toolbarSlot.getSlotName(), component, index);
        }
    }

    public <T extends Component> T getToolbarComponent(ToolbarSlot toolbarSlot, String id) {
        Objects.requireNonNull(id, "Id can't be null");
        return (T)SlotUtil.getComponent(this, toolbarSlot.getSlotName(), id);
    }

    public void removeToolbarComponent(ToolbarSlot toolbarSlot, String id) {
        Objects.requireNonNull(id, "Id can't be null");
        SlotUtil.removeComponent(this, toolbarSlot.getSlotName(), id);
    }

    public void removeToolbarComponent(ToolbarSlot toolbarSlot, Component component) {
        Objects.requireNonNull(component, "Button can't be null");
        SlotUtil.removeComponent(this, toolbarSlot.getSlotName(), component);
    }

    @Deprecated
    public Button getCustomButton(String id) {
        Objects.requireNonNull(id, "Id can't be null");
        return SlotUtil.getButton(this, id);
    }

    @Deprecated
    public void removeCustomButton(String id) {
        Objects.requireNonNull(id, "Id can't be null");
        SlotUtil.removeButton(this, id);
    }

    @Deprecated
    public void removeCustomButton(Button button) {
        Objects.requireNonNull(button, "Button can't be null");
        SlotUtil.removeButton(this, button);
    }

    public void addStandardToolbarButtonShortcut(ToolbarButton toolbarButton, Number keyCode, Boolean shortKey, Boolean shiftKey, Boolean altKey) {
        this.getElement().executeJs("$0.addStandardButtonBinding($1, $2, $3, $4, $5)", new Serializable[]{this.getElement(), toolbarButton.getButtonName(), keyCode, shortKey, shiftKey, altKey});
    }

    public void addToobarFocusShortcut(Number keyCode, Boolean shortKey, Boolean shiftKey, Boolean altKey) {
        this.getElement().executeJs("$0.addToolbarFocusBinding($1, $2, $3, $4)", new Serializable[]{this.getElement(), keyCode, shortKey, shiftKey, altKey});
    }

    public void replaceStandardToolbarButtonIcon(ToolbarButton toolbarButton, Icon icon) {
        Objects.requireNonNull(icon, "Icon can't be null");
        SlotUtil.replaceStandardButtonIcon(this, icon, toolbarButton.getButtonName());
    }

    public static class RichTextEditorI18n
    implements Serializable {
        private String undo;
        private String redo;
        private String bold;
        private String italic;
        private String underline;
        private String strike;
        private String h1;
        private String h2;
        private String h3;
        private String subscript;
        private String superscript;
        private String listOrdered;
        private String listBullet;
        private String deindent;
        private String indent;
        private String alignLeft;
        private String alignCenter;
        private String alignRight;
        private String alignJustify;
        private String image;
        private String link;
        private String blockquote;
        private String codeBlock;
        private String readonly;
        private String placeholder;
        private String placeholderAppearance;
        private String placeholderComboBoxLabel;
        private String placeholderAppearanceLabel1;
        private String placeholderAppearanceLabel2;
        private String placeholderDialogTitle;
        private String clean;

        public String getUndo() {
            return this.undo;
        }

        public RichTextEditorI18n setUndo(String undo) {
            this.undo = undo;
            return this;
        }

        public String getRedo() {
            return this.redo;
        }

        public RichTextEditorI18n setRedo(String redo) {
            this.redo = redo;
            return this;
        }

        public String getBold() {
            return this.bold;
        }

        public RichTextEditorI18n setBold(String bold) {
            this.bold = bold;
            return this;
        }

        public String getItalic() {
            return this.italic;
        }

        public RichTextEditorI18n setItalic(String italic) {
            this.italic = italic;
            return this;
        }

        public String getUnderline() {
            return this.underline;
        }

        public RichTextEditorI18n setUnderline(String underline) {
            this.underline = underline;
            return this;
        }

        public String getStrike() {
            return this.strike;
        }

        public RichTextEditorI18n setStrike(String strike) {
            this.strike = strike;
            return this;
        }

        public String getH1() {
            return this.h1;
        }

        public RichTextEditorI18n setH1(String h1) {
            this.h1 = h1;
            return this;
        }

        public String getH2() {
            return this.h2;
        }

        public RichTextEditorI18n setH2(String h2) {
            this.h2 = h2;
            return this;
        }

        public String getH3() {
            return this.h3;
        }

        public RichTextEditorI18n setH3(String h3) {
            this.h3 = h3;
            return this;
        }

        public String getSubscript() {
            return this.subscript;
        }

        public RichTextEditorI18n setSubscript(String subscript) {
            this.subscript = subscript;
            return this;
        }

        public String getSuperscript() {
            return this.superscript;
        }

        public RichTextEditorI18n setSuperscript(String superscript) {
            this.superscript = superscript;
            return this;
        }

        public String getListOrdered() {
            return this.listOrdered;
        }

        public RichTextEditorI18n setListOrdered(String listOrdered) {
            this.listOrdered = listOrdered;
            return this;
        }

        public String getListBullet() {
            return this.listBullet;
        }

        public RichTextEditorI18n setListBullet(String listBullet) {
            this.listBullet = listBullet;
            return this;
        }

        public String getDeindent() {
            return this.deindent;
        }

        public RichTextEditorI18n setDeindent(String deindent) {
            this.deindent = deindent;
            return this;
        }

        public String getIndent() {
            return this.indent;
        }

        public RichTextEditorI18n setIndent(String indent) {
            this.indent = indent;
            return this;
        }

        public String getAlignLeft() {
            return this.alignLeft;
        }

        public RichTextEditorI18n setAlignLeft(String alignLeft) {
            this.alignLeft = alignLeft;
            return this;
        }

        public String getAlignCenter() {
            return this.alignCenter;
        }

        public RichTextEditorI18n setAlignCenter(String alignCenter) {
            this.alignCenter = alignCenter;
            return this;
        }

        public String getAlignRight() {
            return this.alignRight;
        }

        public RichTextEditorI18n setAlignRight(String alignRight) {
            this.alignRight = alignRight;
            return this;
        }

        public String getAlignJustify() {
            return this.alignJustify;
        }

        public RichTextEditorI18n setAlignJustify(String alignJustify) {
            this.alignJustify = alignJustify;
            return this;
        }

        public String getImage() {
            return this.image;
        }

        public RichTextEditorI18n setImage(String image) {
            this.image = image;
            return this;
        }

        public String getLink() {
            return this.link;
        }

        public RichTextEditorI18n setLink(String link) {
            this.link = link;
            return this;
        }

        public String getBlockquote() {
            return this.blockquote;
        }

        public RichTextEditorI18n setBlockquote(String blockquote) {
            this.blockquote = blockquote;
            return this;
        }

        public String getCodeBlock() {
            return this.codeBlock;
        }

        public RichTextEditorI18n setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        public String getReadonly() {
            return this.readonly;
        }

        public RichTextEditorI18n setReadonly(String readonly) {
            this.readonly = readonly;
            return this;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public RichTextEditorI18n setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public String getPlaceholderAppearance() {
            return this.placeholderAppearance;
        }

        public RichTextEditorI18n setPlaceholderAppeance(String placeholderAppearance) {
            this.placeholderAppearance = placeholderAppearance;
            return this;
        }

        public String getPlaceholderComboBoxLabel() {
            return this.placeholderComboBoxLabel;
        }

        public RichTextEditorI18n setPlaceholderComboBoxLabel(String placeholderComboBoxLabel) {
            this.placeholderComboBoxLabel = placeholderComboBoxLabel;
            return this;
        }

        public String setPlaceholderAppearanceLabel1() {
            return this.placeholderAppearanceLabel1;
        }

        public RichTextEditorI18n getPlaceholderAppearanceLabel1(String placeholderAppearanceLabel1) {
            this.placeholderAppearanceLabel1 = placeholderAppearanceLabel1;
            return this;
        }

        public String setPlaceholderAppearanceLabel2() {
            return this.placeholderAppearanceLabel2;
        }

        public RichTextEditorI18n getPlaceholderAppearanceLabel2(String placeholderAppearanceLabel2) {
            this.placeholderAppearanceLabel2 = placeholderAppearanceLabel2;
            return this;
        }

        public String getPlaceholderDialogTitle() {
            return this.placeholderDialogTitle;
        }

        public RichTextEditorI18n getPlaceholderDialogTitle(String placeholderDialogTitle) {
            this.placeholderDialogTitle = placeholderDialogTitle;
            return this;
        }

        public String getClean() {
            return this.clean;
        }

        public RichTextEditorI18n setClean(String clean) {
            this.clean = clean;
            return this;
        }

        public String toString() {
            return "[" + this.undo + ", " + this.redo + ", " + this.bold + ", " + this.italic + ", " + this.underline + ", " + this.strike + ", " + this.h1 + ", " + this.h2 + ", " + this.h3 + ", " + this.subscript + ", " + this.superscript + ", " + this.listOrdered + ", " + this.listBullet + ", " + this.deindent + ", " + this.indent + ", " + this.alignLeft + ", " + this.alignCenter + ", " + this.alignRight + ", " + this.alignJustify + ", " + this.image + ", " + this.link + ", " + this.blockquote + ", " + this.codeBlock + ", " + this.readonly + ", " + this.placeholder + ", " + this.placeholderAppearance + ", " + this.placeholderComboBoxLabel + ", " + this.placeholderAppearanceLabel1 + ", " + this.placeholderAppearanceLabel2 + ", " + this.placeholderDialogTitle + ", " + this.clean + "]";
        }
    }

    public static enum ToolbarButton {
        UNDO,
        REDO,
        BOLD,
        ITALIC,
        UNDERLINE,
        STRIKE,
        H1,
        H2,
        H3,
        SUBSCRIPT,
        SUPERSCRIPT,
        LIST_ORDERED,
        LIST_BULLET,
        DEINDENT,
        INDENT,
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT,
        ALIGN_JUSTIFY,
        IMAGE,
        LINK,
        BLOCKQUOTE,
        CODE_BLOCK,
        WHITESPACE,
        READONLY,
        CLEAN,
        PLACEHOLDER,
        PLACEHOLDER_APPEARANCE;


        public String toString() {
            String name = this.getButtonName();
            return "\"" + name + "\"";
        }

        public String getButtonName() {
            String str = this.name().toLowerCase();
            CharSequence[] parts = str.split("_");
            if (parts.length == 1) {
                return str;
            }
            for (int i = 1; i < parts.length; ++i) {
                parts[i] = Character.toUpperCase(((String)parts[i]).charAt(0)) + ((String)parts[i]).substring(1);
            }
            return String.join((CharSequence)"", parts);
        }
    }
}

