/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.ApplyFilterListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.popover.Popover;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.Optional;

public class FilterField
extends Popover {
    private static final String APPLY_BTN_KEY = "filter-field.apply.btn";
    private static final String RESET_BTN_KEY = "filter-field.reset.btn";
    private Button applyButton;
    private Button resetButton;
    private VerticalLayout rootLayout = new VerticalLayout();
    private Div filterComponentDiv;
    private Component filterComponent;
    private ApplyFilterListener applyFilterListener;

    public FilterField() {
        this.rootLayout.setSpacing(false);
        this.filterComponentDiv = new Div();
        this.rootLayout.add(new Component[]{this.filterComponentDiv, this.createButtonsLayout()});
        this.add(new Component[]{this.rootLayout});
        this.getElement().getThemeList().add((Object)"enhanced-grid-filter-field");
        this.setOpenOnClick(false);
        this.setOpenOnFocus(true);
        this.setOpenOnHover(false);
        this.setCloseOnOutsideClick(true);
        this.setCloseOnEsc(true);
        this.setAutofocus(true);
    }

    private HorizontalLayout createButtonsLayout() {
        this.applyButton = new Button(this.getTranslation(APPLY_BTN_KEY, new Object[0]), (ComponentEventListener & Serializable)e -> this.applyFilter());
        this.applyButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        this.resetButton = new Button(this.getTranslation(RESET_BTN_KEY, new Object[0]), (ComponentEventListener & Serializable)e -> this.resetFilter());
        this.resetButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        HorizontalLayout buttonsLayout = new HorizontalLayout();
        buttonsLayout.setWidthFull();
        buttonsLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        buttonsLayout.add(new Component[]{this.applyButton, this.resetButton});
        return buttonsLayout;
    }

    public void applyFilter() {
        this.applyFilterListener.onApplyFilter(((HasValue)this.filterComponent).getValue());
        this.close();
    }

    public void resetFilter() {
        ((HasValue)this.filterComponent).clear();
    }

    public void addFilterComponent(Component filterComponent) {
        this.filterComponent = filterComponent;
        this.filterComponentDiv.add(new Component[]{filterComponent});
        if (!this.isEmptyFilter()) {
            this.applyFilter();
        }
    }

    public Component getFilterComponent() {
        return this.filterComponent;
    }

    public boolean isEmptyFilter() {
        return ((HasValue)this.filterComponent).isEmpty();
    }

    public void addApplyFilterListener(ApplyFilterListener applyFilterListener) {
        this.applyFilterListener = applyFilterListener;
    }

    public static Optional<FilterField> findComponent(Component component) {
        while (component != null && !(component instanceof FilterField)) {
            component = component.getParent().orElse(null);
        }
        return Optional.ofNullable((FilterField)component);
    }
}

