/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.componentfactory.enhancedgrid.EnhancedGrid;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.data.selection.SingleSelectionEvent;
import com.vaadin.flow.data.selection.SingleSelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import tools.jackson.databind.node.ObjectNode;

public abstract class CustomAbstractGridSingleSelectionModel<T>
extends Grid.AbstractGridExtension<T>
implements GridSingleSelectionModel<T> {
    private T selectedItem;
    private boolean deselectAllowed = true;

    public CustomAbstractGridSingleSelectionModel(Grid<T> grid) {
        super(grid);
    }

    public void selectFromClient(T item) {
        if (Objects.equals(item, this.selectedItem)) {
            return;
        }
        this.doSelect(item, true);
    }

    public void select(T item) {
        if (Objects.equals(item, this.selectedItem)) {
            return;
        }
        T oldItem = this.selectedItem;
        this.doSelect(item, false);
        this.getGrid().doClientSideSelection(Collections.singleton(item));
        if (oldItem != null) {
            this.getGrid().getDataCommunicator().refresh(oldItem);
        }
        if (item != null) {
            this.getGrid().getDataCommunicator().refresh(item);
        }
    }

    public void deselectFromClient(T item) {
        if (this.isSelected(item) && this.isDeselectAllowed()) {
            this.selectFromClient(null);
        }
    }

    public void deselect(T item) {
        if (this.isSelected(item)) {
            this.select(null);
        }
    }

    public Optional<T> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }

    public void setDeselectAllowed(boolean deselectAllowed) {
        this.deselectAllowed = deselectAllowed;
    }

    public boolean isDeselectAllowed() {
        return this.deselectAllowed;
    }

    public SingleSelect<Grid<T>, T> asSingleSelect() {
        return new SingleSelect<Grid<T>, T>(){

            public void setValue(T value) {
                CustomAbstractGridSingleSelectionModel.this.setSelectedItem(value);
            }

            public T getValue() {
                return CustomAbstractGridSingleSelectionModel.this.getSelectedItem().orElse(this.getEmptyValue());
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Grid<T>, T>> listener) {
                Objects.requireNonNull(listener, "listener cannot be null");
                ComponentEventListener & Serializable componentEventListener = (ComponentEventListener & Serializable)event -> listener.valueChanged((HasValue.ValueChangeEvent)((AbstractField.ComponentValueChangeEvent)event));
                return ComponentUtil.addListener((Component)CustomAbstractGridSingleSelectionModel.this.getGrid(), SingleSelectionEvent.class, (ComponentEventListener)componentEventListener);
            }

            public Element getElement() {
                return CustomAbstractGridSingleSelectionModel.this.getGrid().getElement();
            }
        };
    }

    public Registration addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener((Component)this.getGrid(), SingleSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((SelectionEvent)event));
    }

    public Registration addSingleSelectionListener(SingleSelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener((Component)this.getGrid(), SingleSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((SingleSelectionEvent)event));
    }

    public void generateData(T item, ObjectNode jsonObject) {
        if (this.isSelected(item)) {
            jsonObject.put("selected", true);
        }
    }

    protected void remove() {
        super.remove();
        this.deselectAll();
    }

    protected abstract void fireSelectionEvent(SelectionEvent<Grid<T>, T> var1);

    private void doSelect(T item, boolean userOriginated) {
        if (item == null || ((EnhancedGrid)this.getGrid()).getSelectionPredicate().test(item)) {
            T oldValue = this.selectedItem;
            this.selectedItem = item;
            this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new SingleSelectionEvent((Component)this.getGrid(), this.getGrid().asSingleSelect(), oldValue, userOriginated));
        }
    }
}

