/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.componentfactory.enhancedgrid.EnhancedGrid;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.CustomGridSelectionColumn;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tools.jackson.databind.node.ObjectNode;

public abstract class CustomAbstractGridMultiSelectionModel<T>
extends Grid.AbstractGridExtension<T>
implements GridMultiSelectionModel<T> {
    private final Set<T> selected = new LinkedHashSet<T>();
    private final CustomGridSelectionColumn selectionColumn = new CustomGridSelectionColumn(this::clientSelectAll, this::clientDeselectAll);
    private GridMultiSelectionModel.SelectAllCheckboxVisibility selectAllCheckBoxVisibility = GridMultiSelectionModel.SelectAllCheckboxVisibility.DEFAULT;

    public CustomAbstractGridMultiSelectionModel(Grid<T> grid) {
        super(grid);
        this.selectionColumn.setSelectAllCheckBoxVisibility(this.isSelectAllCheckboxVisible());
        if (grid.getElement().getNode().isAttached()) {
            this.insertSelectionColumn(grid, this.selectionColumn);
        } else {
            grid.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> {
                if (grid.getSelectionModel() == this) {
                    this.insertSelectionColumn(grid, this.selectionColumn);
                }
            });
        }
    }

    private void insertSelectionColumn(Grid<T> grid, CustomGridSelectionColumn selectionColumn) {
        grid.getElement().insertChild(0, new Element[]{selectionColumn.getElement()});
    }

    protected void remove() {
        super.remove();
        this.deselectAll();
        if (this.selectionColumn.getElement().getNode().isAttached()) {
            this.getGrid().getElement().removeChild(new Element[]{this.selectionColumn.getElement()});
        }
    }

    public void selectFromClient(T item) {
        if (this.isSelected(item)) {
            return;
        }
        LinkedHashSet<T> oldSelection = new LinkedHashSet<T>(this.selected);
        boolean added = this.selected.add(item);
        if (added) {
            this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new MultiSelectionEvent((Component)this.getGrid(), (HasValue)this.getGrid().asMultiSelect(), oldSelection, true));
            long size = 0L;
            DataProvider dataProvider = this.getGrid().getDataCommunicator().getDataProvider();
            if (!(dataProvider instanceof HierarchicalDataProvider)) {
                size = dataProvider.size(new Query());
            }
            this.selectionColumn.setSelectAllCheckboxState(size == (long)this.selected.size());
        }
    }

    public void deselectFromClient(T item) {
        if (!this.isSelected(item)) {
            return;
        }
        LinkedHashSet<T> oldSelection = new LinkedHashSet<T>(this.selected);
        boolean removed = this.selected.remove(item);
        if (removed) {
            this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new MultiSelectionEvent((Component)this.getGrid(), (HasValue)this.getGrid().asMultiSelect(), oldSelection, true));
        }
        this.selectionColumn.setSelectAllCheckboxState(false);
    }

    public Set<T> getSelectedItems() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.selected));
    }

    public Optional<T> getFirstSelectedItem() {
        return this.selected.stream().findFirst();
    }

    public void select(T item) {
        if (this.isSelected(item)) {
            return;
        }
        HashSet<T> selected = new HashSet<T>();
        if (item != null) {
            selected.add(item);
        }
        this.doUpdateSelection(selected, Collections.emptySet(), false);
    }

    public void deselect(T item) {
        if (!this.isSelected(item)) {
            return;
        }
        HashSet<T> deselected = new HashSet<T>();
        if (item != null) {
            deselected.add(item);
        }
        this.doUpdateSelection(Collections.emptySet(), deselected, false);
        this.selectionColumn.setSelectAllCheckboxState(false);
    }

    public void selectAll() {
        this.updateSelection(this.getGrid().getDataCommunicator().getDataProvider().fetch(new Query()).collect(Collectors.toSet()), Collections.emptySet());
        this.selectionColumn.setSelectAllCheckboxState(true);
    }

    public void deselectAll() {
        this.updateSelection(Collections.emptySet(), this.getSelectedItems());
        this.selectionColumn.setSelectAllCheckboxState(false);
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        Objects.requireNonNull(addedItems, "added items cannot be null");
        Objects.requireNonNull(removedItems, "removed items cannot be null");
        this.doUpdateSelection(addedItems, removedItems, false);
    }

    public boolean isSelected(T item) {
        return this.getSelectedItems().stream().anyMatch(selectedItem -> Objects.equals(this.getItemId(selectedItem), this.getItemId(item)));
    }

    public MultiSelect<Grid<T>, T> asMultiSelect() {
        return new MultiSelect<Grid<T>, T>(){

            public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Grid<T>, Set<T>>> listener) {
                Objects.requireNonNull(listener, "listener cannot be null");
                ComponentEventListener & Serializable componentEventListener = (ComponentEventListener & Serializable)event -> listener.valueChanged((HasValue.ValueChangeEvent)((AbstractField.ComponentValueChangeEvent)event));
                return ComponentUtil.addListener((Component)CustomAbstractGridMultiSelectionModel.this.getGrid(), MultiSelectionEvent.class, (ComponentEventListener)componentEventListener);
            }

            public Registration addSelectionListener(MultiSelectionListener<Grid<T>, T> listener) {
                return CustomAbstractGridMultiSelectionModel.this.addMultiSelectionListener(listener);
            }

            public void deselectAll() {
                CustomAbstractGridMultiSelectionModel.this.deselectAll();
            }

            public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
                CustomAbstractGridMultiSelectionModel.this.updateSelection(addedItems, removedItems);
            }

            public Element getElement() {
                return CustomAbstractGridMultiSelectionModel.this.getGrid().getElement();
            }

            public Set<T> getSelectedItems() {
                return CustomAbstractGridMultiSelectionModel.this.getSelectedItems();
            }
        };
    }

    public Registration addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener((Component)this.getGrid(), MultiSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((SelectionEvent)event));
    }

    public Registration addMultiSelectionListener(MultiSelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener((Component)this.getGrid(), MultiSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((MultiSelectionEvent)event));
    }

    public void setSelectAllCheckboxVisibility(GridMultiSelectionModel.SelectAllCheckboxVisibility selectAllCheckBoxVisibility) {
        this.selectAllCheckBoxVisibility = selectAllCheckBoxVisibility;
        this.selectionColumn.setSelectAllCheckBoxVisibility(this.isSelectAllCheckboxVisible());
    }

    public GridMultiSelectionModel.SelectAllCheckboxVisibility getSelectAllCheckboxVisibility() {
        return this.selectAllCheckBoxVisibility;
    }

    public boolean isSelectAllCheckboxVisible() {
        switch (this.selectAllCheckBoxVisibility) {
            case DEFAULT: {
                return this.getGrid().getDataCommunicator().getDataProvider().isInMemory();
            }
            case HIDDEN: {
                return false;
            }
            case VISIBLE: {
                return true;
            }
        }
        throw new IllegalStateException(String.format("Select all checkbox visibility is set to an unsupported value: %s", this.selectAllCheckBoxVisibility));
    }

    public void generateData(T item, ObjectNode jsonObject) {
        if (this.isSelected(item)) {
            jsonObject.put("selected", true);
        }
    }

    public void setSelectionColumnFrozen(boolean frozen) {
        this.selectionColumn.setFrozen(frozen);
    }

    public boolean isSelectionColumnFrozen() {
        return this.selectionColumn.isFrozen();
    }

    protected abstract void fireSelectionEvent(SelectionEvent<Grid<T>, T> var1);

    private void clientSelectAll() {
        if (!this.isSelectAllCheckboxVisible()) {
            return;
        }
        DataProvider dataProvider = this.getGrid().getDataCommunicator().getDataProvider();
        Stream allItemsStream = dataProvider instanceof HierarchicalDataProvider ? this.fetchAllHierarchical((HierarchicalDataProvider)dataProvider) : dataProvider.fetch(new Query());
        this.doUpdateSelection(allItemsStream.collect(Collectors.toSet()), Collections.emptySet(), true);
        this.selectionColumn.setSelectAllCheckboxState(true);
    }

    private Stream<T> fetchAllHierarchical(HierarchicalDataProvider<T, ?> dataProvider) {
        return this.fetchAllDescendants(null, dataProvider);
    }

    private Stream<T> fetchAllDescendants(T parent, HierarchicalDataProvider<T, ?> dataProvider) {
        if (parent != null && !dataProvider.hasChildren(parent)) {
            return Stream.empty();
        }
        List children = dataProvider.fetchChildren(new HierarchicalQuery(null, parent)).collect(Collectors.toList());
        if (children.isEmpty()) {
            return Stream.empty();
        }
        return children.stream().flatMap(child -> Stream.concat(Stream.of(child), this.fetchAllDescendants(child, dataProvider)));
    }

    private void clientDeselectAll() {
        if (!this.isSelectAllCheckboxVisible()) {
            return;
        }
        this.doUpdateSelection(Collections.emptySet(), this.getSelectedItems(), true);
        this.selectionColumn.setSelectAllCheckboxState(false);
    }

    private void doUpdateSelection(Set<T> addedItems, Set<T> removedItems, boolean userOriginated) {
        Set filteredAddedItems = addedItems.stream().filter(item -> ((EnhancedGrid)this.getGrid()).getSelectionPredicate().test(item)).collect(Collectors.toSet());
        Map addedItemsMap = this.mapItemsById(filteredAddedItems);
        Map removedItemsMap = this.mapItemsById(removedItems);
        addedItemsMap.keySet().stream().filter(removedItemsMap::containsKey).collect(Collectors.toList()).forEach(key -> {
            addedItemsMap.remove(key);
            removedItemsMap.remove(key);
        });
        this.doUpdateSelection(addedItemsMap, removedItemsMap, userOriginated);
    }

    private void doUpdateSelection(Map<Object, T> addedItems, Map<Object, T> removedItems, boolean userOriginated) {
        Map<Object, T> selectedMap = this.mapItemsById(this.selected);
        if (selectedMap.keySet().containsAll(addedItems.keySet()) && Collections.disjoint(selectedMap.keySet(), removedItems.keySet())) {
            return;
        }
        LinkedHashSet<T> oldSelection = new LinkedHashSet<T>(this.selected);
        removedItems.keySet().forEach(selectedMap::remove);
        selectedMap.putAll(addedItems);
        this.selected.clear();
        this.selected.addAll(selectedMap.values());
        this.sendSelectionUpdate(new LinkedHashSet<T>(addedItems.values()), arg_0 -> ((Grid)this.getGrid()).doClientSideSelection(arg_0));
        this.sendSelectionUpdate(new LinkedHashSet<T>(removedItems.values()), arg_0 -> ((Grid)this.getGrid()).doClientSideDeselection(arg_0));
        this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new MultiSelectionEvent((Component)this.getGrid(), (HasValue)this.getGrid().asMultiSelect(), oldSelection, userOriginated));
        if (!removedItems.isEmpty()) {
            this.selectionColumn.setSelectAllCheckboxState(false);
        }
    }

    private Map<Object, T> mapItemsById(Set<T> items) {
        return items.stream().collect(LinkedHashMap::new, (map, item) -> map.put(this.getItemId(item), item), Map::putAll);
    }

    private void sendSelectionUpdate(Set<T> updatedItems, Consumer<Set<T>> clientSideUpdater) {
        Set<Object> activeItems = updatedItems.stream().filter(arg_0 -> ((Grid)this.getGrid()).isInActiveRange(arg_0)).collect(Collectors.toSet());
        if (activeItems.isEmpty()) {
            return;
        }
        activeItems.forEach(arg_0 -> ((DataCommunicator)this.getGrid().getDataCommunicator()).refresh(arg_0));
        clientSideUpdater.accept(activeItems);
    }

    private Object getItemId(T item) {
        return this.getGrid().getDataCommunicator().getDataProvider().getId(item);
    }
}

