/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;

public class CancelEditConfirmDialog
extends Dialog {
    private Paragraph message;
    private Button confirmButton;
    private Button cancelButton;

    public CancelEditConfirmDialog(String text, String confirmText, String cancelText, SerializableRunnable onConfirmCallback, SerializableRunnable onCancelCallback) {
        this.setCloseOnEsc(true);
        this.setCloseOnOutsideClick(false);
        this.message = new Paragraph(text);
        this.confirmButton = new Button(confirmText, (ComponentEventListener & Serializable)e -> {
            onConfirmCallback.run();
            this.close();
        });
        this.cancelButton = new Button(cancelText, (ComponentEventListener & Serializable)e -> {
            if (onCancelCallback != null) {
                onCancelCallback.run();
            }
            this.close();
        });
        HorizontalLayout buttonsLayout = new HorizontalLayout();
        buttonsLayout.setWidthFull();
        buttonsLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        buttonsLayout.add(new Component[]{this.confirmButton, this.cancelButton});
        this.add(new Component[]{this.message, buttonsLayout});
    }

    public Paragraph getMessage() {
        return this.message;
    }

    public Button getConfirmButton() {
        return this.confirmButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }
}

