/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.enhancedtreegrid;

import com.vaadin.componentfactory.enhancedgrid.EnhancedColumn;
import com.vaadin.componentfactory.enhancedgrid.EnhancedGrid;
import com.vaadin.componentfactory.enhancedtreegrid.EnhancedHierarchyColumnComponentRenderer;
import com.vaadin.componentfactory.enhancedtreegrid.TreeGridDataCommunicator;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.grid.Filter;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridArrayUpdater;
import com.vaadin.flow.component.grid.dataview.GridDataView;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.treegrid.CollapseEvent;
import com.vaadin.flow.component.treegrid.ExpandEvent;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HasHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Uses(value=TreeGrid.class)
public class EnhancedTreeGrid<T>
extends EnhancedGrid<T>
implements HasHierarchicalDataProvider<T> {
    public EnhancedTreeGrid() {
        this(50, new TreeDataCommunicatorBuilder());
    }

    protected EnhancedTreeGrid(int pageSize, Grid.DataCommunicatorBuilder<T, GridArrayUpdater> dataCommunicatorBuilder) {
        super(pageSize, dataCommunicatorBuilder);
        this.setUniqueKeyProperty("key");
        this.addTreeDataGenerator();
    }

    private void addTreeDataGenerator() {
        this.addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> {
            if (this.getDataCommunicator().hasChildren(item)) {
                jsonObject.put("children", true);
            }
            if (this.getDataCommunicator().isExpanded(item)) {
                jsonObject.put("expanded", true);
            }
            jsonObject.put("level", this.getDataCommunicator().getDepth(item));
        });
    }

    public EnhancedTreeGrid(Class<T> beanType) {
        this(beanType, true);
    }

    public EnhancedTreeGrid(Class<T> beanType, boolean autoCreateColumns) {
        this(beanType, new TreeDataCommunicatorBuilder(), autoCreateColumns);
    }

    private EnhancedTreeGrid(Class<T> beanType, Grid.DataCommunicatorBuilder<T, GridArrayUpdater> dataCommunicatorBuilder, boolean autoCreateColumns) {
        super(beanType, dataCommunicatorBuilder, autoCreateColumns);
        this.setUniqueKeyProperty("key");
        this.addTreeDataGenerator();
    }

    public EnhancedTreeGrid(HierarchicalDataProvider<T, ?> dataProvider) {
        this();
        this.setDataProvider(dataProvider);
    }

    public void setUniqueKeyDataGenerator(String propertyName, ValueProvider<T, String> uniqueKeyProvider) {
        this.setUniqueKeyProperty(propertyName);
        this.setUniqueKeyProvider(uniqueKeyProvider);
        this.getDataProvider().refreshAll();
    }

    public Registration addExpandListener(ComponentEventListener<ExpandEvent<T, EnhancedTreeGrid<T>>> listener) {
        return ComponentUtil.addListener((Component)this, ExpandEvent.class, listener);
    }

    public Registration addCollapseListener(ComponentEventListener<CollapseEvent<T, EnhancedTreeGrid<T>>> listener) {
        return ComponentUtil.addListener((Component)this, CollapseEvent.class, listener);
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        if (!(dataProvider instanceof HierarchicalDataProvider)) {
            throw new IllegalArgumentException("TreeGrid only accepts hierarchical data providers. An example of interface to be used: HierarchicalDataProvider");
        }
        this.setDataProvider((HierarchicalDataProvider)dataProvider);
    }

    public void setDataProvider(HierarchicalDataProvider<T, ?> hierarchicalDataProvider) {
        super.setDataProvider(hierarchicalDataProvider);
    }

    @Deprecated
    public GridLazyDataView<T> setItems(BackEndDataProvider<T, Void> dataProvider) {
        throw new UnsupportedOperationException("TreeGrid only accepts hierarchical data providers. Use another setDataProvider/setItems method instead with hierarchical data.An example of interface to be used: HierarchicalDataProvider");
    }

    @Deprecated
    public GridLazyDataView<T> setItems(CallbackDataProvider.FetchCallback<T, Void> fetchCallback) {
        throw new UnsupportedOperationException("TreeGrid only accepts hierarchical data providers. Use another setDataProvider/setItems method instead with hierarchical data.An example of interface to be used: HierarchicalDataProvider");
    }

    @Deprecated
    public GridListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        throw new UnsupportedOperationException("TreeGrid only accepts hierarchical data providers. Use another setDataProvider/setItems method instead with hierarchical data.An example of interface to be used: HierarchicalDataProvider");
    }

    @Deprecated
    public GridListDataView<T> setItems(T ... items) {
        throw new UnsupportedOperationException("TreeGrid only accepts hierarchical data providers. Use another setDataProvider/setItems method instead with hierarchical data.An example of interface to be used: HierarchicalDataProvider");
    }

    @Deprecated
    public GridListDataView<T> setItems(Collection<T> items) {
        throw new UnsupportedOperationException("TreeGrid only accepts hierarchical data providers. Use another setDataProvider/setItems method instead with hierarchical data.An example of interface to be used: HierarchicalDataProvider");
    }

    @Deprecated
    public GridListDataView<T> getListDataView() {
        throw new UnsupportedOperationException("TreeGrid does not support list data view.");
    }

    @Deprecated
    public GridLazyDataView<T> getLazyDataView() {
        throw new UnsupportedOperationException("TreeGrid does not support lazy data view.");
    }

    @Deprecated
    public GridDataView<T> getGenericDataView() {
        throw new UnsupportedOperationException("TreeGrid does not support generic data view.");
    }

    public EnhancedColumn<T> addHierarchyColumn(ValueProvider<T, ?> valueProvider) {
        Grid.Column column = this.addColumn((Renderer)LitRenderer.of((String)"<vaadin-grid-tree-toggle @click=${onClick} .leaf=${!model.hasChildren} .expanded=${live(model.expanded)} .level=${model.level}>${item.name}</vaadin-grid-tree-toggle>").withProperty("name", (ValueProvider & Serializable)value -> {
            Object name = valueProvider.apply(value);
            return name == null ? "" : String.valueOf(name);
        }).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (this.getDataCommunicator().hasChildren(item)) {
                if (this.isExpanded(item)) {
                    this.collapse((Collection)List.of(item), true);
                } else {
                    this.expand((Collection)List.of(item), true);
                }
            }
        }));
        SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> EnhancedTreeGrid.compareMaybeComparables((Object)valueProvider.apply(a), (Object)valueProvider.apply(b));
        column.setComparator((Comparator)comparator);
        return column;
    }

    public <V extends Component> EnhancedColumn<T> addComponentHierarchyColumn(ValueProvider<T, V> componentProvider) {
        return this.addColumn((Renderer)new EnhancedHierarchyColumnComponentRenderer<V, T>(componentProvider, this));
    }

    public Grid.Column<T> setHierarchyColumn(String propertyName) {
        return this.setHierarchyColumn(propertyName, null);
    }

    public Grid.Column<T> setHierarchyColumn(String propertyName, ValueProvider<T, ?> valueProvider) {
        List<String> currentPropertyList = this.getColumns().stream().map(Grid.Column::getKey).filter(Objects::nonNull).collect(Collectors.toList());
        this.resetColumns(propertyName, valueProvider, currentPropertyList);
        return this.getColumnByKey(propertyName);
    }

    public Grid.Column<T> setColumns(String hierarchyPropertyName, ValueProvider<T, ?> valueProvider, Collection<String> propertyNames) {
        if (this.getPropertySet() == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type. To construct Grid from a bean type, please provide a beanType argumentto the constructor: Grid<Person> grid = new Grid<>(Person.class)");
        }
        this.resetColumns(hierarchyPropertyName, valueProvider, propertyNames);
        return this.getColumnByKey(hierarchyPropertyName);
    }

    private void resetColumns(String hierarchyPropertyName, ValueProvider<T, ?> valueProvider, Collection<String> propertyList) {
        this.getColumns().forEach(arg_0 -> ((EnhancedTreeGrid)this).removeColumn(arg_0));
        propertyList.stream().distinct().forEach(key -> this.addColumn((String)key, hierarchyPropertyName, valueProvider));
    }

    private void addColumn(String key, String hierarchyPropertyName, ValueProvider<T, ?> valueProvider) {
        if (key.equals(hierarchyPropertyName)) {
            this.addHierarchyColumn(hierarchyPropertyName, valueProvider);
        } else {
            this.addColumn(key);
        }
    }

    private void addHierarchyColumn(String hierarchyPropertyName, ValueProvider<T, ?> valueProvider) {
        if (valueProvider != null) {
            this.addHierarchyColumn(valueProvider).setKey(hierarchyPropertyName);
        } else {
            this.addHierarchyColumn(hierarchyPropertyName);
        }
    }

    private Grid.Column<T> addHierarchyColumn(String propertyName) {
        PropertyDefinition property;
        if (this.getPropertySet() == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type. To construct Grid from a bean type, please provide a beanType argumentto the constructor: Grid<Person> grid = new Grid<>(Person.class)");
        }
        Objects.requireNonNull(propertyName, "Hierarchy Property name can't be null");
        try {
            property = (PropertyDefinition)this.getPropertySet().getProperty(propertyName).get();
        }
        catch (IllegalArgumentException | NoSuchElementException exception) {
            throw new IllegalArgumentException("There is no such hierarchy property name in the beanType used for construction of the grid:Trying to get '" + propertyName + "' from '" + String.valueOf(this.getPropertySet()) + "'");
        }
        return this.addHierarchyColumn(property);
    }

    private Grid.Column<T> addHierarchyColumn(PropertyDefinition<T, ?> property) {
        Grid.Column column = this.addHierarchyColumn((ValueProvider & Serializable)item -> String.valueOf(property.getGetter().apply(item))).setHeader(property.getCaption());
        try {
            return column.setKey(property.getName());
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Multiple columns for the same property: " + property.getName());
        }
    }

    @ClientCallable(value=DisabledUpdateMode.ONLY_WHEN_ENABLED)
    private void updateExpandedState(String key, boolean expanded) {
        Object item = this.getDataCommunicator().getKeyMapper().get(key);
        if (item != null) {
            if (expanded) {
                this.expand((Collection<T>)Arrays.asList(item), true);
            } else {
                this.collapse((Collection<T>)Arrays.asList(item), true);
            }
        }
    }

    public void expand(T ... items) {
        this.expand((Collection<T>)Arrays.asList(items));
    }

    public void expand(Collection<T> items) {
        this.expand(items, false);
    }

    protected void expand(Collection<T> items, boolean userOriginated) {
        Collection expandedItems = this.getDataCommunicator().expand(items);
        this.fireEvent((ComponentEvent)new ExpandEvent((Component)this, userOriginated, expandedItems));
    }

    public void expandRecursively(Stream<T> items, int depth) {
        this.expandRecursively(items.toList(), depth);
    }

    public void expandRecursively(Collection<T> items, int depth) {
        Collection expandedItems = this.getDataCommunicator().expand(this.getItemsWithChildrenRecursively(items, depth));
        this.fireEvent((ComponentEvent)new ExpandEvent((Component)this, false, expandedItems));
    }

    public void collapse(T ... items) {
        this.collapse((Collection<T>)Arrays.asList(items));
    }

    public void collapse(Collection<T> items) {
        this.collapse(items, false);
    }

    protected void collapse(Collection<T> items, boolean userOriginated) {
        Collection collapsedItems = this.getDataCommunicator().collapse(items);
        this.fireEvent((ComponentEvent)new CollapseEvent((Component)this, userOriginated, collapsedItems));
    }

    public void collapseRecursively(Stream<T> items, int depth) {
        this.collapseRecursively(items.toList(), depth);
    }

    public void collapseRecursively(Collection<T> items, int depth) {
        Collection collapsedItems = this.getDataCommunicator().collapse(this.getItemsWithChildrenRecursively(items, depth));
        this.fireEvent((ComponentEvent)new CollapseEvent((Component)this, false, collapsedItems));
    }

    protected Collection<T> getItemsWithChildrenRecursively(Collection<T> items, int depth) {
        ArrayList itemsWithChildren = new ArrayList();
        if (depth < 0) {
            return itemsWithChildren;
        }
        items.stream().filter(arg_0 -> this.getDataCommunicator().hasChildren(arg_0)).forEach(item -> {
            itemsWithChildren.add(item);
            itemsWithChildren.addAll(this.getItemsWithChildrenRecursively(this.getDataProvider().fetchChildren(new HierarchicalQuery(null, item)).collect(Collectors.toList()), depth - 1));
        });
        return itemsWithChildren;
    }

    public boolean isExpanded(T item) {
        return this.getDataCommunicator().isExpanded(item);
    }

    public HierarchicalDataCommunicator<T> getDataCommunicator() {
        return (HierarchicalDataCommunicator)super.getDataCommunicator();
    }

    public HierarchicalDataProvider<T, SerializablePredicate<T>> getDataProvider() {
        if (!(super.getDataProvider() instanceof HierarchicalDataProvider)) {
            return null;
        }
        return (HierarchicalDataProvider)super.getDataProvider();
    }

    public void scrollToIndex(int index) {
        this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.getElement().executeJs("this.scrollToIndex($0);", new Object[]{index})));
    }

    public void scrollToIndex(int ... path) {
        if (!this.getDataProvider().getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED)) {
            throw new UnsupportedOperationException("scrollToIndex(int...) is supported only for data providers that use HierarchyFormat.NESTED. For HierarchyFormat.FLATTENED, use scrollToIndex(int) with a flat index instead.\n");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("At least one index should be provided.");
        }
        String joinedIndexes = Arrays.stream(path).mapToObj(String::valueOf).collect(Collectors.joining(","));
        this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.getElement().executeJs("this.scrollToIndex(" + joinedIndexes + ");", new Object[0])));
    }

    public void scrollToEnd() {
        this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.getElement().executeJs("this.scrollToIndex(...Array(10).fill(-1))", new Object[0])));
    }

    @AllowInert
    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    int setViewportRangeByIndexPath(int[] path, int padding) {
        int pageSize = this.getPageSize();
        int maxAllowedItems = 10 * Math.max(50, pageSize);
        if (maxAllowedItems < padding) {
            throw new IllegalArgumentException(String.format("Requested viewport size (%d items) exceeds security limit (%d items max). Consider reducing the grid height or increasing the page size to at least %d if it's a valid request.", padding, maxAllowedItems, (int)Math.ceil((double)padding / 10.0)));
        }
        TreeGridDataCommunicator dataCommunicator = (TreeGridDataCommunicator)this.getDataCommunicator();
        int flatIndex = dataCommunicator.resolveIndexPath(path);
        dataCommunicator.preloadFlatRangeForward(flatIndex, padding + pageSize);
        dataCommunicator.preloadFlatRangeBackward(flatIndex, padding + pageSize);
        flatIndex = dataCommunicator.resolveIndexPath(path);
        int startIndex = flatIndex - padding;
        int endIndex = flatIndex + padding;
        int startPage = Math.max(0, startIndex / pageSize);
        int endPage = endIndex / pageSize;
        dataCommunicator.setViewportRange(startPage * pageSize, (endPage - startPage + 1) * pageSize);
        return flatIndex;
    }

    public void scrollToItem(T item) {
        Objects.requireNonNull(item, "Item to scroll to cannot be null.");
        int[] indexPath = ((TreeGridDataCommunicator)this.getDataCommunicator()).resolveItem(item);
        if (indexPath.length == 1) {
            this.scrollToIndex(indexPath[0]);
        } else {
            this.scrollToIndex(indexPath);
        }
    }

    @Override
    protected void applyFilterPredicate(SerializablePredicate<T> finalPredicate) {
        HierarchicalDataProvider<T, SerializablePredicate<T>> dataProvider = this.getDataProvider();
        if (dataProvider instanceof TreeDataProvider) {
            ((TreeDataProvider)dataProvider).setFilter(finalPredicate);
        } else if (dataProvider instanceof HierarchicalConfigurableFilterDataProvider) {
            ((HierarchicalConfigurableFilterDataProvider)dataProvider).setFilter(new Filter<T>(finalPredicate));
        }
    }

    private static class TreeDataCommunicatorBuilder<T>
    extends Grid.DataCommunicatorBuilder<T, GridArrayUpdater> {
        private TreeDataCommunicatorBuilder() {
        }

        protected DataCommunicator<T> build(Element element, CompositeDataGenerator<T> dataGenerator, GridArrayUpdater arrayUpdater, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
            return new TreeGridDataCommunicator<T>(element, dataGenerator, (ArrayUpdater)arrayUpdater, uniqueKeyProviderSupplier);
        }
    }
}

