/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.enhancedtreegrid;

import com.vaadin.componentfactory.enhancedtreegrid.EnhancedTreeGrid;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EnhancedHierarchyColumnComponentRenderer<COMPONENT extends Component, SOURCE>
extends ComponentRenderer<COMPONENT, SOURCE> {
    public EnhancedHierarchyColumnComponentRenderer(ValueProvider<SOURCE, COMPONENT> componentProvider, EnhancedTreeGrid<SOURCE> grid) {
        super(componentProvider);
        this.withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (grid.isExpanded(item)) {
                grid.collapse((Collection)List.of(item), true);
            } else {
                grid.expand((Collection)List.of(item), true);
            }
        });
        this.withProperty("children", (ValueProvider & Serializable)item -> grid.getDataCommunicator().hasChildren(item));
    }

    protected String getTemplateExpression() {
        String clickListener = "e => requestAnimationFrame(() => { e.defaultPrevented && onClick(e) })";
        return "<vaadin-grid-tree-toggle @click=${" + clickListener + "} class=${item.cssClassName} .leaf=${!item.children} .expanded=${model.expanded} .level=${model.level}>" + super.getTemplateExpression() + "</vaadin-grid-tree-toggle>";
    }
}

