/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.enhancedgrid;

import com.vaadin.componentfactory.enhancedgrid.EnhancedColumn;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.ApplyFilterListener;
import com.vaadin.flow.component.grid.CancelEditConfirmDialog;
import com.vaadin.flow.component.grid.ClientItemToggleEvent;
import com.vaadin.flow.component.grid.CustomAbstractGridMultiSelectionModel;
import com.vaadin.flow.component.grid.CustomAbstractGridSingleSelectionModel;
import com.vaadin.flow.component.grid.Filter;
import com.vaadin.flow.component.grid.FilterClickedEvent;
import com.vaadin.flow.component.grid.FilterFieldDto;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridArrayUpdater;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import tools.jackson.databind.node.ObjectNode;

@CssImport(value="./styles/enhanced-grid-selection-disabled.css", themeFor="vaadin-grid")
public class EnhancedGrid<T>
extends Grid<T>
implements BeforeLeaveObserver,
ApplyFilterListener {
    private static final String CANCEL_EDIT_MSG_KEY = "cancel-edit-dialog.text";
    private static final String CANCEL_EDIT_CONFIRM_BTN_KEY = "cancel-edit-dialog.confirm-btn";
    private static final String CANCEL_EDIT_CANCEL_BTN_KEY = "cancel-edit-dialog.cancel-btn";
    private SerializablePredicate<T> selectionPredicate = (SerializablePredicate & Serializable)item -> true;
    private DataGenerator<T> generateSelectionGenerator;
    private SerializablePredicate<T> editablePredicate = (SerializablePredicate & Serializable)item -> true;
    private boolean showCancelEditDialog = true;
    private Icon filterIcon;
    SerializableFunction<T, String> selectionDisabled = (SerializableFunction & Serializable)item -> {
        if (!this.selectionPredicate.test(item)) {
            return "selection-disabled";
        }
        return "";
    };
    private SerializableFunction<T, String> defaultPartNameGenerator = (SerializableFunction & Serializable)item -> null;

    public EnhancedGrid() {
    }

    public EnhancedGrid(DataProvider<T, Void> dataProvider) {
        super(dataProvider);
    }

    public EnhancedGrid(BackEndDataProvider<T, Void> dataProvider) {
        super(dataProvider);
    }

    public EnhancedGrid(InMemoryDataProvider<T> inMemoryDataProvider) {
        super(inMemoryDataProvider);
    }

    public EnhancedGrid(ListDataProvider<T> dataProvider) {
        super(dataProvider);
    }

    public EnhancedGrid(Collection<T> items) {
        super(items);
    }

    public EnhancedGrid(int pageSize) {
        super(pageSize);
    }

    public EnhancedGrid(Class<T> beanType, boolean autoCreateColumns) {
        super(beanType, autoCreateColumns);
    }

    public EnhancedGrid(Class<T> beanType) {
        super(beanType);
    }

    protected <U extends GridArrayUpdater, B extends Grid.DataCommunicatorBuilder<T, U>> EnhancedGrid(Class<T> beanType, B dataCommunicatorBuilder) {
        super(beanType, dataCommunicatorBuilder);
    }

    protected <U extends GridArrayUpdater, B extends Grid.DataCommunicatorBuilder<T, U>> EnhancedGrid(Class<T> beanType, B dataCommunicatorBuilder, boolean autoCreateColumns) {
        super(beanType, dataCommunicatorBuilder, autoCreateColumns);
    }

    protected <U extends GridArrayUpdater, B extends Grid.DataCommunicatorBuilder<T, U>> EnhancedGrid(int pageSize, B dataCommunicatorBuilder) {
        super(pageSize, dataCommunicatorBuilder);
    }

    public SerializablePredicate<T> getSelectionPredicate() {
        return this.selectionPredicate;
    }

    public void setSelectionPredicate(SerializablePredicate<T> selectionPredicate) {
        this.selectionPredicate = selectionPredicate;
        if (this.generateSelectionGenerator != null) {
            this.generateSelectionGenerator.destroyAllData();
        }
        this.generateSelectionGenerator = this::generateSelectionAccess;
        this.addDataGenerator(this.generateSelectionGenerator);
        this.setPartNameGenerator(this.defaultPartNameGenerator);
    }

    public void setPartNameGenerator(SerializableFunction<T, String> partNameGenerator) {
        this.defaultPartNameGenerator = partNameGenerator;
        super.setPartNameGenerator((SerializableFunction & Serializable)item -> {
            String className = Optional.ofNullable((String)this.defaultPartNameGenerator.apply(item)).orElse("");
            return StringUtils.trimToNull((String)((String)this.selectionDisabled.apply(item) + " " + className));
        });
    }

    private void generateSelectionAccess(T item, ObjectNode jsonObject) {
        if (!this.selectionPredicate.test(item)) {
            jsonObject.put("selectionDisabled", true);
        }
    }

    public GridSelectionModel<T> setSelectionMode(Grid.SelectionMode selectionMode) {
        if (selectionMode == Grid.SelectionMode.MULTI) {
            Objects.requireNonNull(selectionMode, "Selection mode cannot be null.");
            CustomAbstractGridMultiSelectionModel model = new CustomAbstractGridMultiSelectionModel<T>(this){

                public void setDragSelect(boolean b) {
                }

                public boolean isDragSelect() {
                    return false;
                }

                @Override
                protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                    ComponentUtil.fireEvent((Component)this.getGrid(), (ComponentEvent)((ComponentEvent)event));
                }

                public Registration addClientItemToggleListener(ComponentEventListener<ClientItemToggleEvent<T>> listener) {
                    return null;
                }
            };
            this.setSelectionModel((GridSelectionModel)model, selectionMode);
            return model;
        }
        if (selectionMode == Grid.SelectionMode.SINGLE) {
            CustomAbstractGridSingleSelectionModel model = new CustomAbstractGridSingleSelectionModel<T>(this){

                @Override
                protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                    ComponentUtil.fireEvent((Component)this.getGrid(), (ComponentEvent)((ComponentEvent)event));
                }

                @Override
                public void setDeselectAllowed(boolean deselectAllowed) {
                    super.setDeselectAllowed(deselectAllowed);
                    this.getGrid().getElement().executeJs("this.$connector.deselectAllowed = $0", new Object[]{deselectAllowed});
                }
            };
            this.setSelectionModel((GridSelectionModel)model, selectionMode);
            return model;
        }
        return super.setSelectionMode(selectionMode);
    }

    public void setEditablePredicate(SerializablePredicate<T> editablePredicate) {
        this.editablePredicate = editablePredicate;
    }

    public boolean isEditable(T item) {
        return this.editablePredicate.test(item);
    }

    public void editItem(T item) {
        if (!this.isEditable(item)) {
            return;
        }
        Object onEditItem = this.getEditor().getItem();
        if (item.equals(onEditItem)) {
            return;
        }
        if (onEditItem != null && this.allowCancelEditDialogDisplay()) {
            this.cancelEditItem(item, null, null);
        } else {
            this.getEditor().editItem(item);
        }
    }

    public void cancelEdit() {
        if (this.getEditor().getItem() != null) {
            if (this.allowCancelEditDialogDisplay()) {
                this.cancelEditItem(null, null, null);
            } else {
                this.getEditor().cancel();
            }
        }
    }

    protected void cancelEditWithCancelCallback(SerializableRunnable onCancelCallback) {
        if (this.getEditor().getItem() != null) {
            if (this.allowCancelEditDialogDisplay()) {
                this.cancelEditItem(null, null, onCancelCallback);
            } else {
                this.getEditor().cancel();
            }
        }
    }

    protected void cancelEditItem(T newEditItem, BeforeLeaveEvent.ContinueNavigationAction action, SerializableRunnable onCancelCallback) {
        String text = this.getTranslation(CANCEL_EDIT_MSG_KEY, new Object[0]);
        String confirmText = this.getTranslation(CANCEL_EDIT_CONFIRM_BTN_KEY, new Object[0]);
        String cancelText = this.getTranslation(CANCEL_EDIT_CANCEL_BTN_KEY, new Object[0]);
        SerializableRunnable & Serializable onConfirmCallback = action != null ? (SerializableRunnable & Serializable)() -> this.onConfirmEditItem(newEditItem, action) : (SerializableRunnable & Serializable)() -> this.onConfirmEditItem(newEditItem);
        new CancelEditConfirmDialog(text, confirmText, cancelText, onConfirmCallback, onCancelCallback).open();
    }

    protected void onConfirmEditItem(T newEditItem) {
        this.getEditor().cancel();
        if (newEditItem != null) {
            this.getEditor().editItem(newEditItem);
        }
    }

    protected void onConfirmEditItem(T newEditItem, BeforeLeaveEvent.ContinueNavigationAction action) {
        this.onConfirmEditItem(null);
        action.proceed();
    }

    public void setShowCancelEditDialog(boolean showCancelEditDialog) {
        this.showCancelEditDialog = showCancelEditDialog;
    }

    protected boolean allowCancelEditDialogDisplay() {
        return this.showCancelEditDialog && this.getEditor().isBuffered();
    }

    public void beforeLeave(BeforeLeaveEvent event) {
        Object onEditItem = this.getEditor().getItem();
        if (onEditItem != null && this.allowCancelEditDialogDisplay()) {
            BeforeLeaveEvent.ContinueNavigationAction action = event.postpone();
            this.cancelEditItem(null, action, null);
        }
    }

    protected BiFunction<Renderer<T>, String, Grid.Column<T>> getDefaultColumnFactory() {
        return (renderer, columnId) -> new EnhancedColumn(this, (String)columnId, renderer);
    }

    public EnhancedColumn<T> addColumn(ValueProvider<T, ?> valueProvider) {
        return (EnhancedColumn)super.addColumn(valueProvider);
    }

    protected <C extends Grid.Column<T>> C addColumn(ValueProvider<T, ?> valueProvider, BiFunction<Renderer<T>, String, C> columnFactory) {
        EnhancedColumn column = (EnhancedColumn)super.addColumn(valueProvider, columnFactory);
        column.setValueProvider(valueProvider);
        return (C)((Object)column);
    }

    public <V extends Comparable<? super V>> EnhancedColumn<T> addColumn(ValueProvider<T, V> valueProvider, String ... sortingProperties) {
        return (EnhancedColumn)super.addColumn(valueProvider, sortingProperties);
    }

    public EnhancedColumn<T> addColumn(Renderer<T> renderer) {
        return (EnhancedColumn)super.addColumn(renderer);
    }

    public <V extends Component> EnhancedColumn<T> addComponentColumn(ValueProvider<T, V> componentProvider) {
        return (EnhancedColumn)super.addComponentColumn(componentProvider);
    }

    public EnhancedColumn<T> getColumnByKey(String columnKey) {
        return (EnhancedColumn)super.getColumnByKey(columnKey);
    }

    protected void setColumnKey(String key, EnhancedColumn<T> column) {
        super.setColumnKey(key, column);
    }

    @Override
    public void onApplyFilter(Object filter) {
        this.applyFilter();
    }

    public void applyFilter() {
        ArrayList<Predicate<Object>> predicates = new ArrayList<Predicate<Object>>();
        for (Grid.Column column : this.getColumns()) {
            EnhancedColumn enhancedColumn = (EnhancedColumn)column;
            if (enhancedColumn.getFilter() == null) continue;
            ValueProvider columnValueProvider = enhancedColumn.getValueProvider();
            Predicate filterPredicate = ((FilterFieldDto)enhancedColumn.getFilter().getValue()).getFilterPredicate();
            predicates.add(p -> filterPredicate.test(columnValueProvider.apply(p)));
            enhancedColumn.updateFilterButtonStyle();
        }
        SerializablePredicate & Serializable finalPredicate = (SerializablePredicate & Serializable)t -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        };
        this.applyFilterPredicate(finalPredicate);
    }

    protected void applyFilterPredicate(SerializablePredicate<T> finalPredicate) {
        DataProvider dataProvider = this.getDataProvider();
        if (dataProvider instanceof ListDataProvider) {
            ((ListDataProvider)dataProvider).setFilter(finalPredicate);
        } else if (dataProvider instanceof ConfigurableFilterDataProvider) {
            ((ConfigurableFilterDataProvider)dataProvider).setFilter(new Filter<T>(finalPredicate));
        }
    }

    public void clearAllFilters() {
        for (Grid.Column column : this.getColumns()) {
            EnhancedColumn enhancedColumn = (EnhancedColumn)column;
            if (enhancedColumn.getFilter() == null) continue;
            enhancedColumn.clearFilter();
        }
        this.applyFilter();
    }

    public Registration addFilterClickedEventListener(ComponentEventListener<FilterClickedEvent<T>> listener) {
        return this.addListener(FilterClickedEvent.class, listener);
    }

    public void setFilterIcon(Icon filterIcon) {
        this.filterIcon = filterIcon;
        this.updateFilterIcon();
    }

    private void updateFilterIcon() {
        if (this.filterIcon != null) {
            for (Grid.Column column : this.getColumns()) {
                EnhancedColumn enhancedColumn = (EnhancedColumn)column;
                enhancedColumn.setFilterIcon(this.filterIcon);
            }
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        for (Grid.Column column : this.getColumns()) {
            EnhancedColumn enhancedColumn = (EnhancedColumn)column;
            enhancedColumn.renderHeader();
            enhancedColumn.updateFilterButtonStyle();
        }
        this.updateFilterIcon();
    }
}

