/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory.enhancedgrid;

import com.vaadin.componentfactory.enhancedgrid.EnhancedGrid;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.grid.FilterField;
import com.vaadin.flow.component.grid.FilterFieldDto;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.SortOrderProvider;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;

@Uses(value=Icon.class)
@JsModule(value="./src/enhanced-grid-sorter.js")
public class EnhancedColumn<T>
extends Grid.Column<T>
implements BeforeEnterObserver {
    private HasValueAndElement<?, ? extends FilterFieldDto> filter;
    private ValueProvider<T, ?> valueProvider;
    private EnhancedGrid<T> grid;
    private FilterField filterField;
    private Component headerComponent;
    private String filterIcon;

    public EnhancedColumn(EnhancedGrid<T> grid, String columnId, Renderer<T> renderer) {
        super(grid, columnId, renderer);
        this.grid = grid;
    }

    public EnhancedColumn<T> setHeader(String labelText, HasValueAndElement<?, ? extends FilterFieldDto> filter) {
        if (filter != null) {
            Span headerComponent = new Span();
            headerComponent.getElement().setText(labelText);
            this.addFilterButtonToHeader((Component)headerComponent, filter);
            return this.setHeader((Component)headerComponent);
        }
        return this.setHeader(labelText);
    }

    public EnhancedColumn<T> setHeader(Component headerComponent, HasValueAndElement<?, ? extends FilterFieldDto> filter) {
        if (filter != null) {
            this.addFilterButtonToHeader(headerComponent, filter);
        }
        return this.setHeader(headerComponent);
    }

    public EnhancedColumn<T> setHeader(Component headerComponent) {
        this.renderHeader();
        return (EnhancedColumn)super.setHeader(headerComponent);
    }

    protected void renderHeader() {
        if (this.isFilterable()) {
            this.grid.getElement().executeJs("monkeyPatchHeaderRenderer(this.$connector, $0)", new Object[]{this.getInternalId()});
        }
    }

    public EnhancedColumn<T> setHeader(String labelText) {
        return (EnhancedColumn)super.setHeader(labelText);
    }

    protected void addFilterButtonToHeader(Component headerComponent, HasValueAndElement<?, ? extends FilterFieldDto> filter) {
        this.filter = filter;
        this.headerComponent = headerComponent;
        this.filterField = new FilterField();
        this.filterField.addApplyFilterListener(this.grid);
        filter.getElement().getComponent().ifPresent(filterComponent -> this.filterField.addFilterComponent((Component)filterComponent));
        this.filterField.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (e.isOpened() && this.grid.getEditor().getItem() != null) {
                if (this.grid.allowCancelEditDialogDisplay()) {
                    this.grid.cancelEditWithCancelCallback((SerializableRunnable & Serializable)() -> this.filterField.close());
                } else {
                    this.grid.getEditor().cancel();
                }
            }
        });
        headerComponent.getElement().appendChild(new Element[]{this.filterField.getElement()});
        this.filterField.setTarget(headerComponent);
        this.grid.addFilterClickedEventListener((ComponentEventListener & Serializable)e -> {
            if (e.buttonId.equals(this.getInternalId())) {
                if (this.filterField.isOpened()) {
                    this.filterField.close();
                } else {
                    this.filterField.open();
                }
            }
        });
    }

    public HasValueAndElement<?, ? extends FilterFieldDto> getFilter() {
        return this.filter;
    }

    protected void updateFilterButtonStyle() {
        if (this.headerComponent != null) {
            this.headerComponent.getElement().executeJs("return", new Object[0]).then((SerializableConsumer & Serializable)ignore -> {
                if (this.hasFilterSelected()) {
                    this.headerComponent.getElement().executeJs("this.parentElement.filtered = true;", new Object[0]);
                } else {
                    this.headerComponent.getElement().executeJs("this.parentElement.filtered = false;", new Object[0]);
                }
            });
        }
    }

    private void updateFilterIcon() {
        if (this.headerComponent != null) {
            this.headerComponent.getElement().executeJs("return", new Object[0]).then((SerializableConsumer & Serializable)ignore -> this.headerComponent.getElement().executeJs("this.parentElement.filtericon = $0;", new Object[]{this.filterIcon}));
        }
    }

    public ValueProvider<T, ?> getValueProvider() {
        if (this.valueProvider != null) {
            return this.valueProvider;
        }
        throw new UnsupportedOperationException("Value provider for column is unknown. Please set one calling setValueProvider method.");
    }

    public void setValueProvider(ValueProvider<T, ?> valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void clearFilter() {
        this.filterField.resetFilter();
    }

    public EnhancedColumn<T> setSortProperty(String ... properties) {
        return (EnhancedColumn)super.setSortProperty(properties);
    }

    public EnhancedColumn<T> setSortOrderProvider(SortOrderProvider provider) {
        return (EnhancedColumn)super.setSortOrderProvider(provider);
    }

    public EnhancedColumn<T> setSortable(boolean sortable) {
        return (EnhancedColumn)super.setSortable(sortable);
    }

    public EnhancedColumn<T> setResizable(boolean resizable) {
        return (EnhancedColumn)super.setResizable(resizable);
    }

    public <V extends Comparable<? super V>> EnhancedColumn<T> setComparator(ValueProvider<T, V> keyExtractor) {
        return (EnhancedColumn)super.setComparator(keyExtractor);
    }

    public EnhancedColumn<T> setComparator(Comparator<T> comparator) {
        return (EnhancedColumn)super.setComparator(comparator);
    }

    protected void setHeaderComponent(Component component) {
        super.setHeaderComponent(component);
    }

    public boolean isFilterable() {
        return this.filterField != null;
    }

    public boolean hasFilterSelected() {
        return this.filter != null && !this.filter.isEmpty();
    }

    protected void setFilterIcon(Icon icon) {
        this.filterIcon = icon.getElement().getAttribute("icon");
        this.updateFilterIcon();
    }

    public EnhancedColumn<T> setKey(String key) {
        return (EnhancedColumn)super.setKey(key);
    }

    public void beforeEnter(BeforeEnterEvent beforeEnterEvent) {
        if (beforeEnterEvent.isRefreshEvent()) {
            Optional.ofNullable(this.getHeaderComponent()).ifPresent(headerComponent -> {
                this.setHeader((Component)headerComponent);
                this.updateFilterButtonStyle();
            });
        }
    }
}

