/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.template.Id;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeFactory;

@Tag(value="vcf-autocomplete")
@NpmPackage.Container(value={@NpmPackage(value="@lit-labs/observers", version="2.0.0"), @NpmPackage(value="@vaadin-component-factory/vcf-autocomplete", version="3.0.0")})
@JsModule(value="@vaadin-component-factory/vcf-autocomplete/src/vcf-autocomplete.js")
public class Autocomplete
extends LitTemplate
implements HasTheme,
HasSize,
HasValue<AutocompleteValueAppliedEvent, String>,
Focusable<Autocomplete>,
HasValidation,
HasPrefix,
HasSuffix {
    private static final String OPTIONS = "options";
    private static final String TEXTFIELD_SELECTOR = "this._textField";
    private static final String LIMIT_PROP = "limit";
    private static final String READONLY_PROP = "readonly";
    private static final String LABEL_PROP = "label";
    private static final String PLACEHOLDER_PROP = "placeholder";
    private static final String VALUE_PROP = "value";
    private static final String ENABLED_PROP = "enabled";
    private boolean invalid;
    private boolean readOnly = false;
    private boolean requiredIndicatorVisible;
    private String errorMessage;
    @Id(value="textField")
    private TextField textField;

    public Autocomplete() {
    }

    public Autocomplete(int limit) {
        this();
        this.setLimit(limit);
    }

    public void setLimit(int limit) {
        this.getElement().setProperty(LIMIT_PROP, (double)limit);
    }

    public void setErrorMessage(String s) {
        this.errorMessage = this.errorMessage;
        this.getElement().executeJs(String.format("%s.errorMessage=$0", TEXTFIELD_SELECTOR), new Object[]{this.errorMessage});
    }

    public String getErrorMessage() {
        return Objects.nonNull(this.errorMessage) ? this.errorMessage : "";
    }

    public void setInvalid(boolean b) {
        this.invalid = this.invalid;
        this.getElement().executeJs(String.format("%s.invalid=$0", TEXTFIELD_SELECTOR), new Object[]{this.invalid});
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setEnabled(boolean enabled) {
        this.getElement().setProperty(ENABLED_PROP, enabled);
    }

    public boolean isEnabled() {
        return this.getElement().getProperty(ENABLED_PROP, true);
    }

    public String getPlaceholderString() {
        return this.getElement().getProperty(PLACEHOLDER_PROP);
    }

    public void setPlaceholder(String placeholder) {
        this.getElement().setProperty(PLACEHOLDER_PROP, placeholder == null ? "" : placeholder);
    }

    public String getLabel() {
        return this.getElement().getProperty(LABEL_PROP);
    }

    public void setLabel(String label) {
        this.getElement().setProperty(LABEL_PROP, label == null ? "" : label);
    }

    public void setOptions(List<String> options) {
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        if (options != null) {
            for (String option : options) {
                arrayNode.add(option);
            }
        }
        this.getElement().setPropertyJson(OPTIONS, (BaseJsonNode)arrayNode);
    }

    public Registration addChangeListener(ComponentEventListener<AucompleteChangeEvent> listener) {
        return this.addListener(AucompleteChangeEvent.class, listener);
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AutocompleteValueAppliedEvent> listener) {
        return this.addAutocompleteValueAppliedListener((ComponentEventListener<AutocompleteValueAppliedEvent>)((ComponentEventListener & Serializable)arg_0 -> listener.valueChanged(arg_0)));
    }

    public Registration addAutocompleteValueAppliedListener(ComponentEventListener<AutocompleteValueAppliedEvent> listener) {
        return this.addListener(AutocompleteValueAppliedEvent.class, listener);
    }

    public void setValue(String value) {
        this.getElement().executeJs("this._setValue(\"" + value + "\");", new Object[0]);
    }

    @Synchronize(property="value", value={"value-changed"})
    public String getValue() {
        return this.getElement().getProperty(VALUE_PROP, "");
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty(READONLY_PROP, readOnly);
        this.getElement().getStyle().set("pointer-events", readOnly ? "none" : "auto");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.requiredIndicatorVisible = requiredIndicatorVisible;
        this.getElement().executeJs(String.format("%s.required=$0", TEXTFIELD_SELECTOR), new Object[]{requiredIndicatorVisible});
    }

    public boolean isRequiredIndicatorVisible() {
        return this.requiredIndicatorVisible;
    }

    public Registration addValueClearListener(ComponentEventListener<ValueClearEvent> listener) {
        return this.addListener(ValueClearEvent.class, listener);
    }

    public void setPrefixComponent(Component component) {
        this.textField.setPrefixComponent(component);
    }

    public Component getPrefixComponent() {
        return this.textField.getPrefixComponent();
    }

    public void setSuffixComponent(Component component) {
        this.textField.setSuffixComponent(component);
    }

    public Component getSuffixComponent() {
        return this.textField.getSuffixComponent();
    }

    @DomEvent(value="value-changed")
    public static class AucompleteChangeEvent
    extends ComponentEvent<Autocomplete> {
        private final String value;

        public AucompleteChangeEvent(Autocomplete source, boolean fromClient, @EventData(value="event.detail.value") String value) {
            super((Component)source, fromClient);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @DomEvent(value="vcf-autocomplete-value-applied")
    public static class AutocompleteValueAppliedEvent
    extends ComponentEvent<Autocomplete>
    implements HasValue.ValueChangeEvent<String> {
        private final String value;

        public AutocompleteValueAppliedEvent(Autocomplete source, boolean fromClient, @EventData(value="event.detail.value") String value) {
            super((Component)source, fromClient);
            this.value = value;
            this.source = source;
        }

        public String getValue() {
            return this.value;
        }

        public HasValue getHasValue() {
            return (HasValue)this.source;
        }

        public String getOldValue() {
            return null;
        }
    }

    @DomEvent(value="clear")
    public static class ValueClearEvent
    extends ComponentEvent<Autocomplete> {
        public ValueClearEvent(Autocomplete source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

