/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.componentfactory;

import com.vaadin.componentfactory.AnchorNavSection;
import com.vaadin.componentfactory.AnchorNavVariant;
import com.vaadin.componentfactory.util.SlotHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vcf-anchor-nav")
@NpmPackage(value="@vaadin-component-factory/vcf-anchor-nav", version="4.0.0")
@JsModule(value="@vaadin-component-factory/vcf-anchor-nav")
public class AnchorNav
extends HtmlContainer
implements HasTheme {
    public AnchorNav() {
        this(false);
    }

    public AnchorNav(boolean noHistory) {
        this.setNoHistory(noHistory);
    }

    public void setNoHistory(boolean noHistory) {
        this.getElement().setProperty("noHistory", noHistory);
    }

    public AnchorNavSection addSection(String title, Component ... components) {
        AnchorNavSection section = new AnchorNavSection(title, components);
        this.add(new Component[]{section});
        return section;
    }

    public AnchorNavSection addSection(Tab sectionTab, Component ... components) {
        AnchorNavSection section = new AnchorNavSection(sectionTab, components);
        this.add(new Component[]{section});
        return section;
    }

    public void setHeaderText(String headerText) {
        if (headerText == null) {
            headerText = "";
        }
        this.setHeader((Component)new H2(headerText));
    }

    public void setHeader(Component header) {
        SlotHelper.clearSlot(this.getElement(), "header");
        if (header != null) {
            header.getElement().setAttribute("slot", "header");
            this.getElement().appendChild(new Element[]{header.getElement()});
        }
    }

    public void addThemeVariants(AnchorNavVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(AnchorNavVariant::getVariantName).collect(Collectors.toList()));
    }

    public void setSelectedSection(int selectedIndex) {
        this.getElement().callJsFunction("_setSelectedSection", new Object[]{selectedIndex});
    }

    public void setSelectedSection(AnchorNavSection selectedSection) {
        int selectedIndex = this.indexOf(selectedSection);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("Section to select must be a child: " + String.valueOf((Object)selectedSection));
        }
        this.setSelectedSection(selectedIndex);
    }

    private int indexOf(AnchorNavSection selectedSection) {
        if (selectedSection == null) {
            throw new IllegalArgumentException("The 'selectedSection' parameter cannot be null");
        }
        Iterator it = ((Stream)this.getChildren().filter(AnchorNavSection.class::isInstance).map(AnchorNavSection.class::cast).sequential()).iterator();
        int index = 0;
        while (it.hasNext()) {
            AnchorNavSection section = (AnchorNavSection)((Object)it.next());
            if (((Object)((Object)section)).equals((Object)selectedSection)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Registration addSelectedSectionChangedListener(ComponentEventListener<SelectedSectionChangedEvent> listener) {
        return this.addListener(SelectedSectionChangedEvent.class, listener);
    }

    @DomEvent(value="selected-changed")
    public static class SelectedSectionChangedEvent
    extends ComponentEvent<AnchorNav> {
        private int sectionIndex;

        public SelectedSectionChangedEvent(AnchorNav source, boolean fromClient, @EventData(value="event.detail.index") int index) {
            super((Component)source, fromClient);
            this.sectionIndex = index;
        }

        public int getSectionIndex() {
            return this.sectionIndex;
        }
    }
}

