/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.server;

import com.google.gson.JsonObject;
import com.vaadin.modernization.minifinder.analytics.AnalyticsService;
import com.vaadin.modernization.minifinder.report.AnalysisPrinter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Optional;

public class ServerService {
    private static final String SERVER_STAGING = "https://mtk-analyzer.stg.vaadin.com/";
    private static final String SERVER_URL = "https://mtk-analyzer.stg.vaadin.com/";
    public static final ServerService INSTANCE = new ServerService();

    private ServerService() {
    }

    public void sendDetails(String email, String details, AnalysisPrinter printer) {
        try {
            URL url = new URL("https://mtk-analyzer.stg.vaadin.com/email");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept", "*/*");
            con.setRequestProperty("Content-type", "application/json");
            con.setDoOutput(true);
            JsonObject requestBody = this.prepareRequestBody(email, details, printer);
            try (OutputStream os = con.getOutputStream();){
                byte[] input = requestBody.toString().getBytes("UTF-8");
                os.write(input, 0, input.length);
            }
            Object builtResponse = "";
            String line = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builtResponse = (String)builtResponse + line;
            }
            reader.close();
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTraceLines = stringWriter.toString();
            printWriter.close();
        }
    }

    public void sendAnalytics(AnalysisPrinter printer) {
        try {
            URL url = new URL("https://mtk-analyzer.stg.vaadin.com/analytics");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept", "*/*");
            con.setRequestProperty("Content-type", "application/json");
            con.setDoOutput(true);
            JsonObject requestBody = this.prepareRequestBody(printer);
            try (OutputStream os = con.getOutputStream();){
                byte[] input = requestBody.toString().getBytes("UTF-8");
                os.write(input, 0, input.length);
            }
            Object builtResponse = "";
            String line = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builtResponse = (String)builtResponse + line;
            }
            reader.close();
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTraceLines = stringWriter.toString();
            printWriter.close();
        }
    }

    private JsonObject prepareRequestBody(AnalysisPrinter printer) {
        JsonObject body = new JsonObject();
        body.addProperty("deviceId", AnalyticsService.INSTANCE.getDeviceId());
        body.addProperty("publicIP", AnalyticsService.INSTANCE.getPublicIP().orElse(""));
        body.addProperty("version", printer.getVersion());
        String eclipseVersion = printer.getEclipseVersion() != null && !printer.getEclipseVersion().isBlank() ? printer.getEclipseVersion() : "";
        body.addProperty("eclipseVersion", eclipseVersion);
        body.addProperty("loc", printer.getLinesOfJava());
        body.addProperty("patterns", printer.getPatterns());
        body.addProperty("vaadinLibs", printer.getVaadinLibs());
        body.addProperty("javaVersion", AnalyticsService.INSTANCE.getJavaVersion());
        String userName = "";
        String proKey = "";
        Optional<Map<String, String>> proKeyContainer = AnalyticsService.INSTANCE.getProKey();
        if (proKeyContainer.isPresent()) {
            Map.Entry<String, String> entry = proKeyContainer.get().entrySet().iterator().next();
            userName = entry.getKey();
            proKey = entry.getValue();
        }
        body.addProperty("userName", userName);
        body.addProperty("proKey", proKey);
        return body;
    }

    private JsonObject prepareRequestBody(String email, String details, AnalysisPrinter printer) {
        JsonObject body = new JsonObject();
        body.addProperty("email", email);
        body.addProperty("details", details);
        body.addProperty("deviceId", AnalyticsService.INSTANCE.getDeviceId());
        body.addProperty("publicIP", AnalyticsService.INSTANCE.getPublicIP().orElse(""));
        body.addProperty("version", printer.getVersion());
        String eclipseVersion = printer.getEclipseVersion() != null && printer.getEclipseVersion().isBlank() ? printer.getEclipseVersion() : "";
        body.addProperty("eclipseVersion", eclipseVersion);
        body.addProperty("loc", printer.getLinesOfJava());
        body.addProperty("patterns", printer.getPatterns());
        body.addProperty("vaadinLibs", printer.getVaadinLibs());
        body.addProperty("javaVersion", AnalyticsService.INSTANCE.getJavaVersion());
        String userName = "";
        String proKey = "";
        Optional<Map<String, String>> proKeyContainer = AnalyticsService.INSTANCE.getProKey();
        if (proKeyContainer.isPresent()) {
            Map.Entry<String, String> entry = proKeyContainer.get().entrySet().iterator().next();
            userName = entry.getKey();
            proKey = entry.getValue();
        }
        body.addProperty("userName", userName);
        body.addProperty("proKey", proKey);
        return body;
    }
}

