/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.minifinder.report.good;

import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.common.SyntacticPrimitive;
import com.vaadin.modernization.minifinder.report.AnalysisCalculator;
import com.vaadin.modernization.minifinder.report.AnalysisPrinter;
import com.vaadin.modernization.minifinder.report.good.GoodNewsAnalysisPrinter;
import com.vaadin.modernization.minifinder.report.good.GoodNewsService;
import com.vaadin.modernization.minifinder.report.good.HashVersion;
import com.vaadin.modernization.minifinder.report.good.TransformableClass;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GoodNewsAnalysisCalculator
extends AnalysisCalculator {
    private static Pattern METHOD_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_]+(?=\\()");
    private Map<String, Integer> pathToCoverage = new HashMap<String, Integer>();
    private Map<String, Integer> pathToConvertibleLoc = new HashMap<String, Integer>();
    private Map<String, Map<String, Integer>> classToMethodCoverage = new HashMap<String, Map<String, Integer>>();
    private Map<Integer, Set<String>> uniqueConvertibleLocUnits = new HashMap<Integer, Set<String>>();
    private Integer convertibleLoc = 0;
    private Integer transformedOrEasyToImplement = 0;

    @Override
    public void processStats(AnalysisPrinter analysisPrinter, List<Occurrence> methodInvocations, Map<String, List<Occurrence>> methodInvocationsPerComponent, List<Occurrence> typeExpressions, List<Occurrence> allOccurrences) {
        super.processStats(analysisPrinter, methodInvocations, methodInvocationsPerComponent, typeExpressions, allOccurrences);
        Map<String, Occurrence> pathToLoc = allOccurrences.stream().filter(o -> SyntacticPrimitive.PFNDR_LOC.getText().equals(o.getOccurrenceType())).collect(Collectors.toMap(Occurrence::getPath, Function.identity()));
        for (Occurrence o2 : allOccurrences) {
            Integer coverage;
            Integer index2;
            String clazzSignature;
            String occurrenceType = o2.getOccurrenceType();
            boolean isCovered = false;
            boolean isMethodInvocation = false;
            HashVersion ruleHashVersion = GoodNewsService.getRuleHashVersion(o2, allOccurrences);
            HashVersion estimateHashVersion = GoodNewsService.getEstimateHashVersion(o2, allOccurrences);
            if (SyntacticPrimitive.JDA_METHOD_INVOCATION.getText().equals(occurrenceType)) {
                clazzSignature = o2.getDependencyClass();
                if (clazzSignature.contains("<")) {
                    int index2 = clazzSignature.indexOf("<");
                    clazzSignature = clazzSignature.substring(0, index2);
                }
                isMethodInvocation = true;
                isCovered = GoodNewsService.INSTANCE.isCovered(ruleHashVersion, this.getSignatureWithQuotes(clazzSignature, o2.getMethodSignature())) || GoodNewsService.INSTANCE.isCovered(ruleHashVersion, this.getSignatureWithoutQuotes(clazzSignature, o2.getMethodSignature()));
                index2 = this.convertibleLoc;
                this.convertibleLoc = this.convertibleLoc + 1;
                this.addUniqueConvertibleLoc(o2);
                this.addPathToConvertibleLoc(o2);
                if (isCovered || GoodNewsService.INSTANCE.isCovered(estimateHashVersion, this.getSignatureWithQuotes(clazzSignature, o2.getMethodSignature())) || GoodNewsService.INSTANCE.isCovered(estimateHashVersion, this.getSignatureWithoutQuotes(clazzSignature, o2.getMethodSignature()))) {
                    index2 = this.transformedOrEasyToImplement;
                    this.transformedOrEasyToImplement = this.transformedOrEasyToImplement + 1;
                }
            } else if (SyntacticPrimitive.CONSTRUCTOR_SIGNATURE.getText().equals(occurrenceType)) {
                clazzSignature = o2.getDependencyClass();
                if (clazzSignature.contains("<")) {
                    int index3 = clazzSignature.indexOf("<");
                    clazzSignature = clazzSignature.substring(0, index3);
                }
                isCovered = GoodNewsService.INSTANCE.isCovered(ruleHashVersion, this.getSignatureWithQuotes(clazzSignature, o2.getMethodSignature())) || GoodNewsService.INSTANCE.isCovered(ruleHashVersion, this.getSignatureWithoutQuotes(clazzSignature, o2.getMethodSignature()));
                index2 = this.convertibleLoc;
                this.convertibleLoc = this.convertibleLoc + 1;
                this.addUniqueConvertibleLoc(o2);
                this.addPathToConvertibleLoc(o2);
                if (isCovered || GoodNewsService.INSTANCE.isCovered(estimateHashVersion, this.getSignatureWithQuotes(clazzSignature, o2.getMethodSignature())) || GoodNewsService.INSTANCE.isCovered(estimateHashVersion, this.getSignatureWithoutQuotes(clazzSignature, o2.getMethodSignature()))) {
                    index2 = this.transformedOrEasyToImplement;
                    this.transformedOrEasyToImplement = this.transformedOrEasyToImplement + 1;
                }
            } else if (AnalysisCalculator.getSupportedPrimitivesText().contains(occurrenceType)) {
                String signature = o2.getInheritedClass();
                if (signature.contains("<")) {
                    int index4 = signature.indexOf("<");
                    signature = signature.substring(0, index4);
                }
                isCovered = GoodNewsService.INSTANCE.isCovered(ruleHashVersion, this.getSignatureWithQuotes(signature, "")) || GoodNewsService.INSTANCE.isCovered(ruleHashVersion, this.getSignatureWithoutQuotes(signature, ""));
                index2 = this.convertibleLoc;
                this.convertibleLoc = this.convertibleLoc + 1;
                this.addUniqueConvertibleLoc(o2);
                this.addPathToConvertibleLoc(o2);
                if (isCovered || GoodNewsService.INSTANCE.isCovered(estimateHashVersion, this.getSignatureWithQuotes(signature, "")) || GoodNewsService.INSTANCE.isCovered(estimateHashVersion, this.getSignatureWithoutQuotes(signature, ""))) {
                    index2 = this.transformedOrEasyToImplement;
                    this.transformedOrEasyToImplement = this.transformedOrEasyToImplement + 1;
                }
            }
            if (isCovered) {
                Integer coverage2 = this.pathToCoverage.get(o2.getPath());
                if (coverage2 == null) {
                    this.pathToCoverage.put(o2.getPath(), 1);
                } else {
                    coverage2 = coverage2 + 1;
                    this.pathToCoverage.put(o2.getPath(), coverage2);
                }
            }
            if (!isCovered || !isMethodInvocation) continue;
            String clazz = o2.getDependencyClass();
            String method = o2.getMethodSignature().trim();
            Map<String, Integer> classMethods = this.classToMethodCoverage.get(clazz);
            if (classMethods == null) {
                classMethods = new HashMap<String, Integer>();
                this.classToMethodCoverage.put(clazz, classMethods);
            }
            if ((coverage = classMethods.get(method)) == null) {
                classMethods.put(method, 1);
                continue;
            }
            coverage = coverage + 1;
            classMethods.put(method, coverage);
        }
        this.setTopTransformableClasses(analysisPrinter, pathToLoc);
        this.setConvertibleApis(analysisPrinter);
        this.setConvertibleLoc(analysisPrinter);
        this.setUniqueConvertibleLoc(analysisPrinter);
        this.setTransformedOrEasyToImplement(analysisPrinter);
    }

    private void addUniqueConvertibleLoc(Occurrence o) {
        int line = o.getLine();
        String path = o.getPath();
        Set<String> units = this.uniqueConvertibleLocUnits.get(line);
        if (units == null) {
            units = new HashSet<String>();
            this.uniqueConvertibleLocUnits.put(line, units);
        }
        units.add(path);
    }

    private String getSignatureWithQuotes(String prefix, String suffix) {
        return prefix.trim() + "\"" + suffix.trim() + "\"";
    }

    private String getSignatureWithoutQuotes(String prefix, String suffix) {
        return prefix.trim() + suffix.trim();
    }

    private void addPathToConvertibleLoc(Occurrence occurrence) {
        Integer coverage = this.pathToConvertibleLoc.get(occurrence.getPath());
        if (coverage == null) {
            this.pathToConvertibleLoc.put(occurrence.getPath(), 1);
        } else {
            coverage = coverage + 1;
            this.pathToConvertibleLoc.put(occurrence.getPath(), coverage);
        }
    }

    private void setConvertibleApis(AnalysisPrinter analysisPrinter) {
        for (String clazz : this.classToMethodCoverage.keySet()) {
            for (Map.Entry<String, Integer> methodCoverage : this.classToMethodCoverage.get(clazz).entrySet()) {
                String methodSignature = methodCoverage.getKey();
                Integer coverage = methodCoverage.getValue();
                Matcher methodNameMatcher = METHOD_NAME_PATTERN.matcher(methodSignature);
                if (!methodNameMatcher.find()) continue;
                String clazzFQN = clazz;
                if (clazzFQN.contains("<")) {
                    clazzFQN = clazz.substring(0, clazz.indexOf("<"));
                }
                String uiFriendlyClazz = clazzFQN.substring(clazzFQN.trim().lastIndexOf(46) + 1);
                String uiFriendlyMethod = methodNameMatcher.group(0);
                ((GoodNewsAnalysisPrinter)analysisPrinter).addConvertibleApi(uiFriendlyClazz, uiFriendlyMethod, coverage.intValue());
            }
        }
    }

    private void setTopTransformableClasses(AnalysisPrinter analysisPrinter, Map<String, Occurrence> pathToLoc) {
        for (Map.Entry<String, Integer> entry : this.pathToCoverage.entrySet()) {
            String path = entry.getKey();
            Integer count = entry.getValue();
            int allLines = pathToLoc.get(path).getLine();
            Integer convertibleLocs = this.pathToConvertibleLoc.get(path);
            String fileNameWithExt = Paths.get(path, new String[0]).getFileName().toString();
            String fileNameNoExt = fileNameWithExt.substring(0, fileNameWithExt.indexOf(46));
            ((GoodNewsAnalysisPrinter)analysisPrinter).addTransformableClass(new TransformableClass(fileNameNoExt, count.intValue(), convertibleLocs.intValue(), allLines));
        }
    }

    private void setConvertibleLoc(AnalysisPrinter analysisPrinter) {
        ((GoodNewsAnalysisPrinter)analysisPrinter).setConvertibleLoc(this.convertibleLoc);
    }

    private void setTransformedOrEasyToImplement(AnalysisPrinter analysisPrinter) {
        ((GoodNewsAnalysisPrinter)analysisPrinter).setTransformedOrEasyToImplement(this.transformedOrEasyToImplement);
    }

    private void setUniqueConvertibleLoc(AnalysisPrinter analysisPrinter) {
        ((GoodNewsAnalysisPrinter)analysisPrinter).setUniqueConvertibleLoc(this.getUniqueConvertibleLoc());
    }

    private Integer getUniqueConvertibleLoc() {
        return this.uniqueConvertibleLocUnits.keySet().stream().mapToInt(key -> this.uniqueConvertibleLocUnits.get(key).size()).sum();
    }
}

