/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.common;

import com.vaadin.modernization.common.LogicalPhysicalProject;
import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.common.Reporting;
import com.vaadin.modernization.common.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.runtime.SubMonitor;

public class FinderCommonUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportfile(String projectName, SubMonitor subMonitor, Reporting reporting) {
        Writer fwl = null;
        Writer fwp = null;
        try {
            String currentUsersHomeDir = System.getProperty("user.home");
            File fout = new File(currentUsersHomeDir);
            File foutfileLogical = null;
            File foutfilePhysical = null;
            if (projectName != null && projectName.length() == 0) {
                foutfileLogical = new File(fout, "PathFiLogical" + System.currentTimeMillis() + ".csv");
                foutfilePhysical = new File(fout, "PathFiPhysical" + System.currentTimeMillis() + ".csv");
            } else {
                foutfileLogical = new File(fout, "Logi" + projectName + System.currentTimeMillis() + ".csv");
                foutfilePhysical = new File(fout, "Fizzy" + projectName + System.currentTimeMillis() + ".csv");
            }
            if (subMonitor != null) {
                subMonitor.setTaskName("Creating output file: " + foutfileLogical.getAbsolutePath());
            }
            fwl = new BufferedWriter(new FileWriter(foutfileLogical));
            fwl.write("Path;Dead;Line;OcType;Source;Dependency;Dependency Raw Type;Inherited Declaration;Inherited Declaration Raw Type\n");
            for (Occurrence o : reporting.getOccurrences()) {
                String inheritedDeclaration = o.getInheritedClass() + o.getMethodSignature();
                String inheritedDeclarationRaw = Utils.removeAllGtLt(inheritedDeclaration);
                if (o.isError()) {
                    fwl.write(o.getPath() + ";" + o.getDead() + ";" + o.getLine() + ";" + o.getOccurrenceType() + ";ERROR ERROR;" + o.getErrorMessage() + ";" + o.getDependencyClassRawType() + ";" + inheritedDeclaration + ";" + inheritedDeclarationRaw + ";\n");
                    continue;
                }
                fwl.write(o.getPath() + ";" + o.getDead() + ";" + o.getLine() + ";" + o.getOccurrenceType() + ";" + o.getSource().replaceAll("\\s", " ") + ";" + o.getDependencyClass() + ";" + o.getDependencyClassRawType() + ";" + inheritedDeclaration + ";" + inheritedDeclarationRaw + "\n");
            }
            fwl.flush();
            fwl.close();
            fwp = new BufferedWriter(new FileWriter(foutfilePhysical));
            fwp.write("PhysicalPath;Physical;Logical;LogicalRaw;Invocations;Evaluations;Annotations\n");
            for (LogicalPhysicalProject lpp : reporting.binaryOccurrences.keySet()) {
                if (reporting.binaryOccurrences.get(lpp) != null) {
                    fwp.write(lpp.getJarPath() + ";" + lpp.getJarName() + ";" + lpp.getPackagePath() + ";" + lpp.getPackageRaw() + ";" + reporting.binaryOccurrences.get((Object)lpp).numberOfMethods + ";" + reporting.binaryOccurrences.get((Object)lpp).numberOfReturns + ";" + reporting.binaryOccurrences.get((Object)lpp).numberOfAnnotations + "\n");
                    continue;
                }
                fwp.write(lpp.getJarPath() + ";" + lpp.getJarName() + ";" + lpp.getPackagePath() + ";" + lpp.getPackageRaw() + ";ERROR ERROR;ERROR ERROR;ERROR ERROR\n");
            }
            fwp.flush();
            fwp.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fwp.close();
                fwl.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static String getSource(String sourceFilePath) {
        try {
            return new String(Files.readAllBytes(Paths.get(sourceFilePath, new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException("Source file not found: " + sourceFilePath);
        }
    }
}

