/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.common;

import com.vaadin.modernization.common.LivitrinLogger;
import com.vaadin.modernization.common.LogicalPhysicalProject;
import com.vaadin.modernization.common.Occurrence;
import com.vaadin.modernization.common.OneIsEnoughException;
import com.vaadin.modernization.common.Reporting;
import com.vaadin.modernization.common.SyntacticPrimitive;
import com.vaadin.modernization.common.Utils;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jface.text.Document;

public class JavaDependencyAnalyzer
extends ASTVisitor {
    private static final String AUTOWIRED_ANNOTATION = "org.springframework.beans.factory.annotation.Autowired";
    private static final String SPRINGVIEW_ANNOTATION = "com.vaadin.spring.annotation.SpringView";
    public String getOccurrenceTypeString;
    String[] needlePrefix = null;
    int flags = 0;
    CompilationUnit unit;
    String physical;
    Reporting reporting;
    QualifiedName watchMeQualifiedName = null;
    TryStatement watchMeTry;
    FieldAccess watchMeFieldAccess = null;
    MethodInvocation watchMeMethodInvocation;
    SuperMethodInvocation watchMeSuperMethodInvocation;
    String mdqn = "";
    private Set<Integer> recordedStaticPositions = new HashSet<Integer>();

    public JavaDependencyAnalyzer(String[] needlePrefix, int flags, CompilationUnit unit, String physicalPath, String source, Reporting reporting) {
        this.needlePrefix = needlePrefix;
        this.flags = flags;
        this.unit = unit;
        this.physical = physicalPath;
        this.reporting = reporting;
        try {
            Document doc = new Document(source);
            Occurrence o = new Occurrence();
            o.setOccurrenceType(SyntacticPrimitive.PFNDR_LOC.getText());
            o.setPath(physicalPath);
            o.setLine(doc.getNumberOfLines());
            reporting.addOccurrence(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean visit(ParameterizedType node) {
        if ((this.flags & SyntacticPrimitive.JDA_TYPE_ARGUMENT.getCode()) == SyntacticPrimitive.JDA_TYPE_ARGUMENT.getCode()) {
            try {
                for (Object obt : node.typeArguments()) {
                    boolean implementsMatches;
                    Type to = (Type)obt;
                    if (to instanceof WildcardType) {
                        to = ((WildcardType)to).getBound();
                    }
                    ITypeBinding ittp = to.resolveBinding();
                    String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                    String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                    boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                    boolean inheritedMatches = inheritanceClass.length() > 0;
                    boolean bl = implementsMatches = implementsInterface.length() > 0;
                    if (!observedMatches && !inheritedMatches && !implementsMatches) continue;
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_ARGUMENT.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                        o.setSource(node.toString());
                        this.reporting.addOccurrence(o);
                    }
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException oneIsEnoughException) {
            }
            catch (Exception e1) {
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, 0);
                o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_ARGUMENT.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.watchMeQualifiedName = node;
        IBinding nodeSubType = node.getQualifier().resolveBinding();
        boolean alsoAddDirectTypeOccurence = false;
        int nodePosition = node.getStartPosition();
        String qualifiedName = null;
        ITypeBinding binding = null;
        String rawQualifiedName = null;
        if (nodeSubType instanceof IVariableBinding) {
            IVariableBinding eleAsVariable = (IVariableBinding)nodeSubType;
            try {
                if (Utils.startsWithAny(eleAsVariable.getType().getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)eleAsVariable.getType())) {
                    alsoAddDirectTypeOccurence = true;
                    qualifiedName = eleAsVariable.getType().getQualifiedName();
                    binding = eleAsVariable.getType();
                    rawQualifiedName = Utils.getRawQualifiedName(eleAsVariable.getType()) + "." + node.getName().toString();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, nodePosition);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_FIELD_ACCESS.getText());
                    o.setSource(node.toString());
                    o.setDependencyClass(qualifiedName, (IBinding)binding);
                    o.setInheritedClass(rawQualifiedName);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    this.reporting.addOccurrence(o);
                }
            }
            catch (Exception e1) {
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, nodePosition);
                o.setOccurrenceType(SyntacticPrimitive.JDA_QUALIFIED_NAME.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        } else if (nodeSubType instanceof ITypeBinding && node.resolveBinding() instanceof IVariableBinding && (node.resolveBinding().getModifiers() & 0x10) == 16) {
            ITypeBinding eleAsType = (ITypeBinding)nodeSubType;
            try {
                if (Utils.startsWithAny(eleAsType.getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)eleAsType)) {
                    alsoAddDirectTypeOccurence = true;
                    qualifiedName = eleAsType.getQualifiedName();
                    binding = eleAsType;
                    rawQualifiedName = Utils.getRawQualifiedName(eleAsType) + "." + node.getName().toString();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, nodePosition);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_QUALIFIED_NAME.getText());
                    o.setSource(node.toString());
                    o.setDependencyClass(qualifiedName, (IBinding)binding);
                    o.setInheritedClass(rawQualifiedName);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    this.reporting.addOccurrence(o);
                }
            }
            catch (Exception e1) {
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, nodePosition);
                o.setOccurrenceType(SyntacticPrimitive.JDA_QUALIFIED_NAME.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        if (alsoAddDirectTypeOccurence) {
            Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, nodePosition);
            o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
            o.setDependencyClass(qualifiedName, (IBinding)binding);
            o.setDead(Utils.codeDedTho((ASTNode)node));
            o.setInheritedClass(rawQualifiedName);
            o.setSource(node.toString());
            this.reporting.addOccurrence(o);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if ((this.flags & SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getCode()) == SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getCode()) {
            try {
                boolean implementsMatches;
                IMethodBinding imb = node.resolveConstructorBinding();
                if (imb == null) {
                    LivitrinLogger.log("ERROR: Constructor binding resolution failed");
                    return true;
                }
                ITypeBinding ittp = imb.getDeclaringClass();
                if (ittp == null) {
                    LivitrinLogger.log("ERROR: Failed to get declaring class from constructor binding");
                    return true;
                }
                String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (observedMatches || inheritedMatches || implementsMatches) {
                    int position = node.getStartPosition();
                    Occurrence oSig = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    oSig.setOccurrenceType(SyntacticPrimitive.CONSTRUCTOR_SIGNATURE.getText());
                    oSig.setDependencyClass(imb.getDeclaringClass().getQualifiedName(), (IBinding)imb.getDeclaringClass());
                    oSig.setMethodSignature(imb.getMethodDeclaration().toString());
                    oSig.setDead(Utils.codeDedTho((ASTNode)node));
                    if (node.toString().length() < 62) {
                        oSig.setSource(node.toString());
                    } else {
                        oSig.setSource(node.toString().substring(0, 60));
                    }
                    if (observedMatches) {
                        this.reporting.addOccurrence(oSig);
                    }
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException imb) {
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
                LivitrinLogger.log("ERROR: " + o.getPath() + " (class instance instantiation) " + e1.getMessage());
            }
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        block19: {
            if ((this.flags & SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getCode()) == SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getCode()) {
                try {
                    boolean implementsMatches;
                    IMethodBinding imb = node.resolveConstructorBinding();
                    if (imb == null) {
                        LivitrinLogger.log("ERROR: Constructor binding resolution failed");
                        return true;
                    }
                    ITypeBinding ittp = imb.getDeclaringClass();
                    if (ittp == null) {
                        LivitrinLogger.log("ERROR: Failed to get declaring class from constructor binding");
                        return true;
                    }
                    boolean isAnonymous = false;
                    if (ittp.isAnonymous() && node.getType() != null) {
                        isAnonymous = true;
                        ittp = node.getType().resolveBinding();
                    }
                    String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                    String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                    boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                    boolean inheritedMatches = inheritanceClass.length() > 0;
                    boolean bl = implementsMatches = implementsInterface.length() > 0;
                    if (!observedMatches && !inheritedMatches && !implementsMatches) break block19;
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    Occurrence oSig = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getText());
                    oSig.setOccurrenceType(SyntacticPrimitive.CONSTRUCTOR_SIGNATURE.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    oSig.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    Object methodSignature = "";
                    if (!isAnonymous) {
                        methodSignature = imb.getMethodDeclaration().toString();
                    } else {
                        methodSignature = "public void <init>()";
                        try {
                            String methodDeclaration = imb.getMethodDeclaration().toString();
                            int initIndex = methodDeclaration.indexOf("<init>");
                            if (initIndex > -1) {
                                methodSignature = "public void " + methodDeclaration.substring(initIndex, methodDeclaration.length());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    oSig.setMethodSignature((String)methodSignature);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    oSig.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(ittp.getQualifiedName());
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    if (node.toString().length() < 62) {
                        o.setSource(node.toString());
                        oSig.setSource(node.toString());
                    } else {
                        o.setSource(node.toString().substring(0, 60));
                        oSig.setSource(node.toString().substring(0, 60));
                    }
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        this.reporting.addOccurrence(oSig);
                    }
                    LivitrinLogger.log(o.getPath() + " (class instance instantiation) " + ittp.getQualifiedName());
                    throw new OneIsEnoughException();
                }
                catch (OneIsEnoughException imb) {
                }
                catch (Exception e1) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getText());
                    o.setError(true);
                    o.setErrorMessage(e1.getMessage());
                    this.reporting.addOccurrence(o);
                    LivitrinLogger.log("ERROR: " + o.getPath() + " (class instance instantiation) " + e1.getMessage());
                }
            }
        }
        return true;
    }

    public boolean visit(TryStatement node) {
        this.watchMeTry = node;
        try {
            for (Object cco : node.catchClauses()) {
                boolean implementsMatches;
                CatchClause cc = (CatchClause)cco;
                SingleVariableDeclaration svd = cc.getException();
                IVariableBinding ifb = svd.resolveBinding();
                ITypeBinding ittp = ifb.getType();
                String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (!observedMatches && !inheritedMatches && !implementsMatches) continue;
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_CATCH_VARIABLE_DECLARATION.getText());
                o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                o.setDead(Utils.codeDedTho((ASTNode)node));
                if (observedMatches) {
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                } else if (inheritedMatches) {
                    o.setInheritedClass(inheritanceClass);
                } else {
                    o.setInheritedClass(implementsInterface);
                }
                o.setSource(node.toString());
                this.reporting.addOccurrence(o);
                if (observedMatches) {
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
                throw new OneIsEnoughException();
            }
        }
        catch (OneIsEnoughException oneIsEnoughException) {
        }
        catch (Exception e1) {
            int position = node.getStartPosition();
            Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
            o.setOccurrenceType(SyntacticPrimitive.JDA_CATCH_VARIABLE_DECLARATION.getText());
            o.setError(true);
            o.setErrorMessage(e1.getMessage());
            this.reporting.addOccurrence(o);
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        try {
            String directParentClass;
            boolean implementsMatches;
            ITypeBinding ittp = node.resolveBinding();
            String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
            String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
            boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
            boolean inheritedMatches = inheritanceClass.length() > 0;
            boolean bl = implementsMatches = implementsInterface.length() > 0;
            if (observedMatches || inheritedMatches || implementsMatches) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_DECLARATION.getText());
                o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                o.setDead(Utils.codeDedTho((ASTNode)node));
                if (observedMatches) {
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                } else if (inheritedMatches) {
                    o.setInheritedClass(inheritanceClass);
                } else {
                    o.setInheritedClass(implementsInterface);
                }
                if (node.toString().length() < 22) {
                    o.setSource(node.toString());
                } else {
                    o.setSource(node.toString().substring(0, 20));
                }
                this.reporting.addOccurrence(o);
            }
            if ((directParentClass = Utils.findNeedleInDirectHierarchy(ittp, this.needlePrefix)) != null && !directParentClass.isEmpty()) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                o.setDead(Utils.codeDedTho((ASTNode)node));
                o.setInheritedClass(directParentClass);
                if (node.toString().length() < 22) {
                    o.setSource(node.toString());
                } else {
                    o.setSource(node.toString().substring(0, 20));
                }
                this.reporting.addOccurrence(o);
            }
            for (String curInterface : Utils.findVaadinInterfaces(ittp, this.needlePrefix)) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                o.setDead(Utils.codeDedTho((ASTNode)node));
                o.setInheritedClass(curInterface);
                if (node.toString().length() < 22) {
                    o.setSource(node.toString());
                } else {
                    o.setSource(node.toString().substring(0, 20));
                }
                this.reporting.addOccurrence(o);
            }
            throw new OneIsEnoughException();
        }
        catch (OneIsEnoughException ittp) {
        }
        catch (Throwable t) {
            int position = node.getStartPosition();
            Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
            o.setOccurrenceType(SyntacticPrimitive.JDA_CATCH_VARIABLE_DECLARATION.getText());
            o.setError(true);
            o.setErrorMessage(t.getMessage());
            this.reporting.addOccurrence(o);
        }
        return true;
    }

    public boolean visit(FieldAccess node) {
        this.watchMeFieldAccess = node;
        if ((this.flags & SyntacticPrimitive.JDA_FIELD_ACCESS.getCode()) == SyntacticPrimitive.JDA_FIELD_ACCESS.getCode()) {
            try {
                IVariableBinding ifb = node.resolveFieldBinding();
                if (ifb.getDeclaringClass() != null && ifb.getDeclaringClass().getQualifiedName() != null && Utils.startsWithAny(ifb.getDeclaringClass().getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)ifb)) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_FIELD_ACCESS.getText());
                    o.setDependencyClass(ifb.getDeclaringClass().getQualifiedName(), (IBinding)ifb.getDeclaringClass());
                    o.setInheritedClass(ifb.getDeclaringClass().getQualifiedName() + "." + node.getName().toString());
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    Expression exp = node.getExpression();
                    String expressionName = "";
                    if (exp != null) {
                        expressionName = exp.resolveTypeBinding().getQualifiedName();
                    }
                    o.setExpressionType(expressionName);
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_FIELD_ACCESS.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        String expressionName;
        Expression exp;
        Occurrence o;
        LogicalPhysicalProject lpp;
        IMethodBinding imb;
        this.watchMeMethodInvocation = node;
        int position = node.getStartPosition();
        try {
            imb = node.resolveMethodBinding();
            if (imb != null) {
                lpp = Utils.getJarDependencyOfMethodDeclaration(imb);
                if (lpp != null) {
                    this.reporting.addOrIncrement(lpp, SyntacticPrimitive.JDA_METHOD_INVOCATION);
                }
                if (Utils.startsWithAny(imb.getDeclaringClass().getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)imb)) {
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_METHOD_INVOCATION.getText());
                    o.setDependencyClass(imb.getDeclaringClass().getQualifiedName(), (IBinding)imb.getDeclaringClass());
                    o.setMethodSignature(imb.getMethodDeclaration().toString());
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    exp = node.getExpression();
                    expressionName = "";
                    if (exp != null) {
                        expressionName = exp.resolveTypeBinding().getQualifiedName();
                    }
                    o.setExpressionType(expressionName);
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    LivitrinLogger.log(o.getPath() + " (method invoc) " + imb.getDeclaringClass().getQualifiedName());
                }
            }
        }
        catch (Exception e1) {
            int eposition = node.getStartPosition();
            o = Occurrence.createGenericOccurrence(this.physical, this.unit, eposition);
            o.setOccurrenceType(SyntacticPrimitive.JDA_METHOD_INVOCATION.getText());
            o.setError(true);
            o.setErrorMessage(e1.getMessage());
            this.reporting.addOccurrence(o);
            LivitrinLogger.log("ERROR:" + o.getPath() + " (method invoc) " + e1.getMessage());
        }
        try {
            imb = node.resolveMethodBinding();
            if (imb != null) {
                lpp = Utils.getJarDependencyOfReturnType(imb);
                if (lpp != null) {
                    this.reporting.addOrIncrement(lpp, SyntacticPrimitive.JDA_EXPRESSION_EVALUATION);
                }
                if (Utils.startsWithAny(imb.getReturnType().getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)imb)) {
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_EXPRESSION_EVALUATION.getText());
                    o.setDependencyClass(imb.getReturnType().getQualifiedName(), (IBinding)imb.getReturnType());
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    exp = node.getExpression();
                    expressionName = "";
                    if (exp != null) {
                        expressionName = exp.resolveTypeBinding().getQualifiedName();
                    }
                    o.setExpressionType(expressionName);
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
            }
        }
        catch (Exception e1) {
            int eposition = node.getStartPosition();
            o = Occurrence.createGenericOccurrence(this.physical, this.unit, eposition);
            o.setOccurrenceType(SyntacticPrimitive.JDA_EXPRESSION_EVALUATION.getText());
            o.setError(true);
            o.setErrorMessage(e1.getMessage());
            this.reporting.addOccurrence(o);
        }
        imb = node.resolveMethodBinding();
        if (imb != null) {
            ITypeBinding expressionTypeBinding;
            String expressionQualifiedName;
            boolean observedMatches;
            int accessKind;
            boolean isStatic;
            boolean bl = isStatic = (imb.getModifiers() & 8) > 0;
            if (isStatic && node.getExpression() instanceof Name && (accessKind = ((Name)node.getExpression()).resolveBinding().getKind()) != 3 && accessKind != 4 && accessKind == 2 && (observedMatches = Utils.startsWithAny(expressionQualifiedName = (expressionTypeBinding = node.getExpression().resolveTypeBinding()).getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)expressionTypeBinding))) {
                Occurrence o2 = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o2.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                o2.setDependencyClass(expressionQualifiedName, (IBinding)expressionTypeBinding);
                o2.setDead(Utils.codeDedTho((ASTNode)node));
                o2.setInheritedClass(Utils.getRawQualifiedName(expressionTypeBinding));
                o2.setSource(node.toString());
                this.reporting.addOccurrence(o2);
            }
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        String expressionName;
        Occurrence o;
        LogicalPhysicalProject lpp;
        IMethodBinding imb;
        this.watchMeSuperMethodInvocation = node;
        int position = node.getStartPosition();
        try {
            imb = node.resolveMethodBinding();
            if (imb != null) {
                lpp = Utils.getJarDependencyOfMethodDeclaration(imb);
                if (lpp != null) {
                    this.reporting.addOrIncrement(lpp, SyntacticPrimitive.JDA_METHOD_INVOCATION);
                }
                if (Utils.startsWithAny(imb.getDeclaringClass().getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)imb)) {
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_METHOD_INVOCATION.getText());
                    o.setDependencyClass(imb.getDeclaringClass().getQualifiedName(), (IBinding)imb.getDeclaringClass());
                    o.setMethodSignature(imb.getMethodDeclaration().toString());
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    expressionName = node.resolveTypeBinding().getQualifiedName();
                    o.setExpressionType(expressionName);
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    LivitrinLogger.log(o.getPath() + " (method invoc) " + imb.getDeclaringClass().getQualifiedName());
                }
            }
        }
        catch (Exception e1) {
            int eposition = node.getStartPosition();
            o = Occurrence.createGenericOccurrence(this.physical, this.unit, eposition);
            o.setOccurrenceType(SyntacticPrimitive.JDA_METHOD_INVOCATION.getText());
            o.setError(true);
            o.setErrorMessage(e1.getMessage());
            this.reporting.addOccurrence(o);
            LivitrinLogger.log("ERROR:" + o.getPath() + " (method invoc) " + e1.getMessage());
        }
        try {
            imb = node.resolveMethodBinding();
            if (imb != null) {
                lpp = Utils.getJarDependencyOfReturnType(imb);
                if (lpp != null) {
                    this.reporting.addOrIncrement(lpp, SyntacticPrimitive.JDA_EXPRESSION_EVALUATION);
                }
                if (Utils.startsWithAny(imb.getReturnType().getQualifiedName(), this.needlePrefix) && !Utils.isTypeDeclaredInSources((IBinding)imb)) {
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_EXPRESSION_EVALUATION.getText());
                    o.setDependencyClass(imb.getReturnType().getQualifiedName(), (IBinding)imb.getReturnType());
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    expressionName = node.resolveTypeBinding().getQualifiedName();
                    o.setExpressionType(expressionName);
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
            }
        }
        catch (Exception e1) {
            int eposition = node.getStartPosition();
            o = Occurrence.createGenericOccurrence(this.physical, this.unit, eposition);
            o.setOccurrenceType(SyntacticPrimitive.JDA_EXPRESSION_EVALUATION.getText());
            o.setError(true);
            o.setErrorMessage(e1.getMessage());
            this.reporting.addOccurrence(o);
        }
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        return this.visitAnnotationSomehow((Annotation)node);
    }

    public boolean visit(MarkerAnnotation node) {
        return this.visitAnnotationSomehow((Annotation)node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        return this.visitAnnotationSomehow((Annotation)node);
    }

    public boolean visitAnnotationSomehow(Annotation node) {
        try {
            String implementsInterface;
            String inheritanceClass;
            LogicalPhysicalProject lpp = Utils.getJarDependencyOfAnnotation(node.resolveAnnotationBinding());
            if (lpp != null) {
                this.reporting.addOrIncrement(lpp, SyntacticPrimitive.JDA_MARKER_ANNOTATION);
            }
            String AnnotationFullyQualifiedName = node.resolveAnnotationBinding().getAnnotationType().getQualifiedName();
            boolean itsAutowired = false;
            boolean itsModifyingAMethod = false;
            boolean thatMethodIsAConstructor = false;
            boolean itsModifyingAField = false;
            boolean itsModifyingAType = false;
            MethodDeclaration md = null;
            FieldDeclaration fd = null;
            TypeDeclaration td = null;
            if (AUTOWIRED_ANNOTATION.equals(AnnotationFullyQualifiedName)) {
                itsAutowired = true;
                if (node.getParent() instanceof MethodDeclaration) {
                    itsModifyingAMethod = true;
                    md = (MethodDeclaration)node.getParent();
                    if (md.isConstructor()) {
                        thatMethodIsAConstructor = true;
                        this.mdqn = md.resolveBinding().getDeclaringClass().getQualifiedName();
                    }
                }
                if (node.getParent() instanceof FieldDeclaration) {
                    itsModifyingAField = true;
                    fd = (FieldDeclaration)node.getParent();
                    this.mdqn = fd.getType().resolveBinding().getQualifiedName();
                }
            } else if (SPRINGVIEW_ANNOTATION.equals(AnnotationFullyQualifiedName)) {
                itsAutowired = true;
                if (node.getParent() instanceof TypeDeclaration) {
                    itsModifyingAType = true;
                    td = (TypeDeclaration)node.getParent();
                } else {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.SPRING_VIEW.getText());
                    o.setDependencyClass("ERROR ERROR: found springview_annotation but can't connnect to parent which is of class " + node.getParent().getClass().getName(), null);
                    o.setSource(node.getParent().toString());
                    this.reporting.addOccurrence(o);
                }
            }
            if (itsAutowired && itsModifyingAMethod && thatMethodIsAConstructor) {
                List constructorParameters = md.parameters();
                for (Object obb : constructorParameters) {
                    boolean implementsMatches;
                    SingleVariableDeclaration svd = (SingleVariableDeclaration)obb;
                    Type t = svd.getType();
                    ITypeBinding ittp = t.resolveBinding();
                    String inheritanceClass2 = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                    String implementsInterface2 = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                    boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix);
                    boolean inheritedMatches = inheritanceClass2.length() > 0;
                    boolean bl = implementsMatches = implementsInterface2.length() > 0;
                    if (!observedMatches && !inheritedMatches && !implementsMatches || Utils.isTypeDeclaredInSources((IBinding)ittp)) continue;
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.SPRING_CONSTRUCTOR_INJECTION.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(ittp.getQualifiedName());
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass2);
                    } else {
                        o.setInheritedClass(implementsInterface2);
                    }
                    o.setSource(node.getParent().toString());
                    this.reporting.addOccurrence(o);
                    if (!observedMatches) continue;
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(ittp.getQualifiedName());
                    o.setSource(node.getParent().toString());
                    this.reporting.addOccurrence(o);
                }
            }
            if (itsAutowired && itsModifyingAField) {
                boolean implementsMatches;
                Type t = fd.getType();
                ITypeBinding ittp = t.resolveBinding();
                inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if ((observedMatches || inheritedMatches || implementsMatches) && !Utils.isTypeDeclaredInSources((IBinding)ittp)) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.SPRING_FIELD_INJECTION.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(ittp.getQualifiedName());
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.getParent().toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(ittp.getQualifiedName());
                        o.setSource(node.getParent().toString());
                        this.reporting.addOccurrence(o);
                    }
                }
            }
            if (itsAutowired && itsModifyingAType) {
                boolean implementsMatches;
                TypeDeclaration tdd = td;
                ITypeBinding tittp = tdd.resolveBinding();
                inheritanceClass = Utils.findNeedleInHierarchy(tittp, this.needlePrefix);
                implementsInterface = Utils.findNeedleInInterfaces(tittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(tittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)tittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (observedMatches || inheritedMatches || implementsMatches) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.SPRING_VIEW.getText());
                    o.setDependencyClass(tittp.getQualifiedName(), (IBinding)tittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(tittp.getQualifiedName());
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.getParent().toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(tittp.getQualifiedName(), (IBinding)tittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(tittp.getQualifiedName());
                        o.setSource(node.getParent().toString());
                        this.reporting.addOccurrence(o);
                    }
                }
            } else {
                boolean implementsMatches;
                ITypeBinding ittp = node.resolveTypeBinding();
                String inheritanceClass3 = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface3 = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix);
                boolean inheritedMatches = inheritanceClass3.length() > 0;
                boolean bl = implementsMatches = implementsInterface3.length() > 0;
                if ((observedMatches || inheritedMatches || implementsMatches) && !Utils.isTypeDeclaredInSources((IBinding)ittp)) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_MARKER_ANNOTATION.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(ittp.getQualifiedName());
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass3);
                    } else {
                        o.setInheritedClass(implementsInterface3);
                    }
                    o.setSource(node.getParent().toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(ittp.getQualifiedName());
                        o.setSource(node.getParent().toString());
                        this.reporting.addOccurrence(o);
                    }
                }
            }
        }
        catch (Exception e1) {
            int position = node.getStartPosition();
            Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
            o.setOccurrenceType(SyntacticPrimitive.SPRING_CONSTRUCTOR_INJECTION.getText());
            o.setError(true);
            o.setErrorMessage(e1.getMessage());
            this.reporting.addOccurrence(o);
            LivitrinLogger.log("ERROR:" + o.getPath() + " (annotat) " + e1.getMessage());
        }
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        if (Modifier.isStatic(node.getModifiers())) {
            int position;
            boolean isCompileTimeConstant = false;
            for (Object fragment : node.fragments()) {
                VariableDeclarationFragment varFragment;
                if (!(fragment instanceof VariableDeclarationFragment) || (varFragment = (VariableDeclarationFragment)fragment).resolveBinding() == null || varFragment.resolveBinding().getConstantValue() == null) continue;
                isCompileTimeConstant = true;
                break;
            }
            if (!isCompileTimeConstant && !this.recordedStaticPositions.contains(position = node.getStartPosition())) {
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_STATIC_FIELD.getText());
                this.reporting.addOccurrence(o);
                this.recordedStaticPositions.add(position);
            }
        } else if ((this.flags & SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getCode()) == SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getCode()) {
            boolean implementsMatches;
            ITypeBinding ittp = node.getType().resolveBinding();
            if (ittp == null) {
                LivitrinLogger.log("ERROR: Failed to get declaring class from field binding");
                return true;
            }
            String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
            String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
            boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
            boolean inheritedMatches = inheritanceClass.length() > 0;
            boolean bl = implementsMatches = implementsInterface.length() > 0;
            if (observedMatches || inheritedMatches || implementsMatches) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(node.getParent() instanceof TypeDeclaration ? SyntacticPrimitive.JDA_TYPE_DECLARATION.getText() : SyntacticPrimitive.JDA_CLASS_INSTANCE_CREATION.getText());
                o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                o.setDead(Utils.codeDedTho((ASTNode)node));
                if (observedMatches) {
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                } else if (inheritedMatches) {
                    o.setInheritedClass(inheritanceClass);
                } else {
                    o.setInheritedClass(implementsInterface);
                }
                o.setSource(node.toString());
                this.reporting.addOccurrence(o);
                if (node.getParent() instanceof TypeDeclaration && observedMatches) {
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
            }
        }
        return super.visit(node);
    }

    public boolean visit(SingleVariableDeclaration node) {
        ITypeBinding ittp = node.getType().resolveBinding();
        if (ittp == null) {
            LivitrinLogger.log("ERROR: Failed to get declaring class from field binding");
            return true;
        }
        String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
        String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
        boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
        boolean inheritedMatches = inheritanceClass.length() > 0;
        boolean implementsMatches = implementsInterface.length() > 0;
        boolean isCatchClause = node.getParent() instanceof CatchClause;
        if (!isCatchClause && (observedMatches || inheritedMatches || implementsMatches)) {
            int position = node.getStartPosition();
            Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
            o.setOccurrenceType(SyntacticPrimitive.JDA_SINGLE_VARIABLE_DECLARATION.getText());
            o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
            o.setDead(Utils.codeDedTho((ASTNode)node));
            if (observedMatches) {
                o.setInheritedClass(Utils.getRawQualifiedName(ittp));
            } else if (inheritedMatches) {
                o.setInheritedClass(inheritanceClass);
            } else {
                o.setInheritedClass(implementsInterface);
            }
            o.setSource(node.toString());
            this.reporting.addOccurrence(o);
            if (observedMatches) {
                o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                o.setDead(Utils.codeDedTho((ASTNode)node));
                o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                o.setSource(node.toString());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }

    public boolean visit(CastExpression node) {
        if ((this.flags & SyntacticPrimitive.JDA_CAST_EXPRESSION.getCode()) == SyntacticPrimitive.JDA_CAST_EXPRESSION.getCode()) {
            try {
                boolean implementsMatches;
                ITypeBinding ittp = node.getType().resolveBinding();
                if (ittp == null) {
                    LivitrinLogger.log("ERROR: Failed to get declaring class from constructor binding");
                    return true;
                }
                String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (observedMatches || inheritedMatches || implementsMatches) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_CAST_EXPRESSION.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                        o.setSource(node.toString());
                        this.reporting.addOccurrence(o);
                    }
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException ittp) {
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_CAST_EXPRESSION.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        if ((this.flags & SyntacticPrimitive.JDA_LOCAL_VAR.getCode()) == SyntacticPrimitive.JDA_LOCAL_VAR.getCode()) {
            try {
                boolean implementsMatches;
                ITypeBinding ittp = node.getType().resolveBinding();
                if (ittp == null) {
                    LivitrinLogger.log("ERROR: Failed to get declaring class from variable declaration");
                    return true;
                }
                if (Objects.equals("var", node.getType().toString())) {
                    return true;
                }
                String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (observedMatches || inheritedMatches || implementsMatches) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_LOCAL_VAR.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                        o.setSource(node.toString());
                        this.reporting.addOccurrence(o);
                    }
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException ittp) {
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_LOCAL_VAR.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }

    public boolean visit(InstanceofExpression node) {
        if ((this.flags & SyntacticPrimitive.JDA_INSTANCE_OF_EXPRESSION.getCode()) == SyntacticPrimitive.JDA_INSTANCE_OF_EXPRESSION.getCode()) {
            try {
                boolean implementsMatches;
                ITypeBinding ittp = node.getRightOperand().resolveBinding();
                if (ittp == null) {
                    LivitrinLogger.log("ERROR: Failed to get declaring class for an instanceof expression");
                    return true;
                }
                String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (observedMatches || inheritedMatches || implementsMatches) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_INSTANCE_OF_EXPRESSION.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                        o.setSource(node.toString());
                        this.reporting.addOccurrence(o);
                    }
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException ittp) {
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_INSTANCE_OF_EXPRESSION.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        int code = this.flags & SyntacticPrimitive.JDA_METHOD_RETURN_TYPE.getCode();
        if (code == SyntacticPrimitive.JDA_METHOD_RETURN_TYPE.getCode() || code == SyntacticPrimitive.JDA_THROW_TYPE.getCode()) {
            try {
                boolean found = false;
                if (!node.isConstructor()) {
                    ITypeBinding ittp = node.getReturnType2().resolveBinding();
                    if (ittp == null) {
                        LivitrinLogger.log("ERROR: Failed to get declaring class for a method return type");
                        return true;
                    }
                    String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                    String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                    boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                    boolean inheritedMatches = inheritanceClass.length() > 0;
                    boolean implementsMatches = implementsInterface.length() > 0;
                    found = false;
                    if (observedMatches || inheritedMatches || implementsMatches) {
                        int position = node.getStartPosition();
                        Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_METHOD_RETURN_TYPE.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        if (observedMatches) {
                            o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                        } else if (inheritedMatches) {
                            o.setInheritedClass(inheritanceClass);
                        } else {
                            o.setInheritedClass(implementsInterface);
                        }
                        o.setSource(node.toString());
                        found = true;
                        this.reporting.addOccurrence(o);
                        if (observedMatches) {
                            o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                            o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                            o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                            o.setDead(Utils.codeDedTho((ASTNode)node));
                            o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                            o.setSource(node.toString());
                            this.reporting.addOccurrence(o);
                        }
                    }
                }
                for (Object exType : node.thrownExceptionTypes()) {
                    boolean implementsMatches;
                    if (!(exType instanceof SimpleType)) continue;
                    ITypeBinding ittp = ((SimpleType)exType).resolveBinding();
                    if (ittp == null) {
                        LivitrinLogger.log("ERROR: Failed to get declaring class for a method thrown type");
                        return true;
                    }
                    String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                    String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                    boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                    boolean inheritedMatches = inheritanceClass.length() > 0;
                    boolean bl = implementsMatches = implementsInterface.length() > 0;
                    if (!observedMatches && !inheritedMatches && !implementsMatches) continue;
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_THROW_TYPE.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.toString());
                    found = true;
                    this.reporting.addOccurrence(o);
                    if (!observedMatches) continue;
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
                if (found) {
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException found) {
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_METHOD_RETURN_TYPE.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }

    public boolean visit(Initializer node) {
        int position = node.getStartPosition();
        if (!this.recordedStaticPositions.contains(position)) {
            Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
            if (Modifier.isStatic(node.getModifiers())) {
                o.setOccurrenceType(SyntacticPrimitive.JDA_STATIC_INITIALIZER.getText());
                this.reporting.addOccurrence(o);
                this.recordedStaticPositions.add(position);
            }
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationExpression node) {
        if ((this.flags & SyntacticPrimitive.JDA_FOR_LOOP_TYPE.getCode()) == SyntacticPrimitive.JDA_FOR_LOOP_TYPE.getCode() && node.getParent() instanceof ForStatement) {
            try {
                boolean implementsMatches;
                ITypeBinding ittp = node.getType().resolveBinding();
                if (ittp == null) {
                    LivitrinLogger.log("ERROR: Failed to get declaring class for a for loop type");
                    return true;
                }
                String inheritanceClass = Utils.findNeedleInHierarchy(ittp, this.needlePrefix);
                String implementsInterface = Utils.findNeedleInInterfaces(ittp, this.needlePrefix);
                boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                boolean inheritedMatches = inheritanceClass.length() > 0;
                boolean bl = implementsMatches = implementsInterface.length() > 0;
                if (observedMatches || inheritedMatches || implementsMatches) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_FOR_LOOP_TYPE.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    if (observedMatches) {
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    } else if (inheritedMatches) {
                        o.setInheritedClass(inheritanceClass);
                    } else {
                        o.setInheritedClass(implementsInterface);
                    }
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    if (observedMatches) {
                        o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                        o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                        o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                        o.setDead(Utils.codeDedTho((ASTNode)node));
                        o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                        o.setSource(node.toString());
                        this.reporting.addOccurrence(o);
                    }
                    throw new OneIsEnoughException();
                }
            }
            catch (OneIsEnoughException ittp) {
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_FOR_LOOP_TYPE.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }

    public boolean visit(TypeParameter node) {
        if ((this.flags & SyntacticPrimitive.JDA_TYPE_PARAMETER.getCode()) == SyntacticPrimitive.JDA_TYPE_PARAMETER.getCode()) {
            for (Object typeBound : node.typeBounds()) {
                if (!(typeBound instanceof SimpleType)) continue;
                try {
                    SimpleType simpleTypeBound = (SimpleType)typeBound;
                    ITypeBinding ittp = simpleTypeBound.resolveBinding();
                    if (ittp == null) {
                        LivitrinLogger.log("ERROR: Failed to get declaring class for a type parameter");
                        continue;
                    }
                    boolean observedMatches = Utils.startsWithAny(ittp.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)ittp);
                    if (!observedMatches) continue;
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_PARAMETER.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                    o.setDependencyClass(ittp.getQualifiedName(), (IBinding)ittp);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(ittp));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
                catch (Exception e1) {
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_PARAMETER.getText());
                    o.setError(true);
                    o.setErrorMessage(e1.getMessage());
                    this.reporting.addOccurrence(o);
                }
            }
        }
        return super.visit(node);
    }

    public boolean visit(TypeLiteral node) {
        if ((this.flags & SyntacticPrimitive.JDA_TYPE_LITERAL.getCode()) == SyntacticPrimitive.JDA_TYPE_LITERAL.getCode()) {
            try {
                ITypeBinding ittp = node.resolveTypeBinding();
                if (ittp == null) {
                    LivitrinLogger.log("ERROR: Failed to get declaring class for a type parameter");
                    return true;
                }
                for (ITypeBinding typeArg : ittp.getTypeArguments()) {
                    boolean observedMatches = Utils.startsWithAny(typeArg.getQualifiedName(), this.needlePrefix) & !Utils.isTypeDeclaredInSources((IBinding)typeArg);
                    if (!observedMatches) continue;
                    int position = node.getStartPosition();
                    Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_LITERAL.getText());
                    o.setDependencyClass(typeArg.getQualifiedName(), (IBinding)typeArg);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(typeArg));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                    o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                    o.setOccurrenceType(SyntacticPrimitive.JDA_DIRECT_TYPE_DEPENDENCY.getText());
                    o.setDependencyClass(typeArg.getQualifiedName(), (IBinding)typeArg);
                    o.setDead(Utils.codeDedTho((ASTNode)node));
                    o.setInheritedClass(Utils.getRawQualifiedName(typeArg));
                    o.setSource(node.toString());
                    this.reporting.addOccurrence(o);
                }
            }
            catch (Exception e1) {
                int position = node.getStartPosition();
                Occurrence o = Occurrence.createGenericOccurrence(this.physical, this.unit, position);
                o.setOccurrenceType(SyntacticPrimitive.JDA_TYPE_LITERAL.getText());
                o.setError(true);
                o.setErrorMessage(e1.getMessage());
                this.reporting.addOccurrence(o);
            }
        }
        return super.visit(node);
    }
}

