/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source.api;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class RemoteServiceUtil {
    private static final boolean encrypted = true;
    private static String dragonflyCorePath = "https://cdn.vaadin.com/dragonfly/dragonfly-core/dragonfly-core-%s.enc";
    private static final String VERSION_URL = "https://cdn.vaadin.com/dragonfly/dragonfly-core/version.txt";
    private static final String PASS = "VaadinModernizationToolKit2024";
    private static String version;

    public static String checkVersion(String localVersionString) {
        boolean isSnapshot;
        if (dragonflyCorePath.endsWith("\\dragonfly-core\\target\\classes\\") || dragonflyCorePath.endsWith("/dragonfly-core/target/classes/")) {
            return "local";
        }
        Object remoteVersionString = null;
        try {
            String inputLine;
            URL resource = new URL(VERSION_URL);
            BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
            ArrayList<String> lines = new ArrayList<String>();
            while ((inputLine = in.readLine()) != null) {
                lines.add(inputLine);
            }
            in.close();
            remoteVersionString = (String)lines.get(0);
        }
        catch (Exception e) {
            return "Can not read version file : https://cdn.vaadin.com/dragonfly/dragonfly-core/version.txt";
        }
        boolean bl = isSnapshot = localVersionString.endsWith(".qualifier") || localVersionString.endsWith("-SNAPSHOT") || localVersionString.split("\\.").length > 3;
        if (isSnapshot) {
            remoteVersionString = localVersionString.endsWith("-SNAPSHOT") ? localVersionString : localVersionString.substring(0, localVersionString.lastIndexOf(46)) + "-SNAPSHOT";
        } else {
            int remoteVersionNumber = RemoteServiceUtil.normalizeVersionString((String)remoteVersionString);
            int localVersionNumber = RemoteServiceUtil.normalizeVersionString(localVersionString);
            if (localVersionNumber < remoteVersionNumber) {
                return "Please Update Plug-in";
            }
        }
        version = remoteVersionString;
        return null;
    }

    public static String getDragonflyCorePath() {
        return dragonflyCorePath;
    }

    public static void setDragonflyCorePath(String dragonflyCorePath) {
        RemoteServiceUtil.dragonflyCorePath = dragonflyCorePath;
    }

    public static InputStream getJarInputStream() throws Exception {
        URL u = new URL(String.format(dragonflyCorePath, version));
        return RemoteServiceUtil.decryptFromInputStream(PASS, u);
    }

    public static int normalizeVersionString(String version) {
        String[] versionParts;
        if (version == null || version.isEmpty()) {
            return 0;
        }
        if (version.indexOf("-") > -1) {
            version = version.substring(0, version.indexOf("-") - 1);
        }
        if ((versionParts = version.split("\\.")).length != 3) {
            return 0;
        }
        int sum = 0;
        for (int i = versionParts.length - 1; i >= 0; --i) {
            boolean isNumber = versionParts[i].chars().allMatch(Character::isDigit);
            if (!isNumber) {
                return 0;
            }
            sum = (int)((double)sum + (double)Integer.parseInt(versionParts[i]) * Math.pow(100.0, 2 - i));
        }
        return sum;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static InputStream decryptFromInputStream(String pass, URL pathToResource) throws Exception {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(pass.toCharArray());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndTripleDES");
        SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        try (BufferedInputStream is = new BufferedInputStream(pathToResource.openStream());){
            ByteArrayInputStream byteArrayInputStream;
            byte[] salt = new byte[8];
            ((InputStream)is).read(salt);
            PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, 100);
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndTripleDES");
            cipher.init(2, (Key)secretKey, pbeParameterSpec);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] output;
                int read;
                byte[] in = new byte[64];
                while ((read = ((InputStream)is).read(in)) != -1) {
                    output = cipher.update(in, 0, read);
                    if (output == null) continue;
                    baos.write(output);
                }
                output = cipher.doFinal();
                if (output != null) {
                    baos.write(output);
                }
                baos.flush();
                byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            return byteArrayInputStream;
        }
    }
}

