/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.ASTVisitor;

public class Visitors {
    private final LinkedHashMap<Integer, List<ASTVisitor>> allVisitors = new LinkedHashMap();
    private ASTVisitor bindingsVisitor;

    public void setBindingsVisitor(ASTVisitor bindingsVisitor) {
        this.bindingsVisitor = bindingsVisitor;
    }

    public ASTVisitor getBindingsVisitor() {
        return this.bindingsVisitor;
    }

    public void set(int executionOrder, List<ASTVisitor> visitors) {
        this.allVisitors.put(executionOrder, visitors);
    }

    public int add(List<ASTVisitor> visitors) {
        int executionOrder = 0;
        if (!this.allVisitors.isEmpty()) {
            executionOrder = this.allVisitors.keySet().stream().reduce(Integer::max).orElse(0);
            ++executionOrder;
        }
        this.allVisitors.put(executionOrder, visitors);
        return executionOrder;
    }

    public void add(int executionOrder, ASTVisitor visitor) {
        List visitors = this.allVisitors.getOrDefault(executionOrder, new ArrayList());
        visitors.add(visitor);
        this.allVisitors.put(executionOrder, visitors);
    }

    public List<ASTVisitor> remove(int executionOrder) {
        return (List)this.allVisitors.remove(executionOrder);
    }

    public List<List<ASTVisitor>> getAll() {
        return this.allVisitors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public int size() {
        return this.allVisitors.size();
    }
}

