/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source;

import com.vaadin.source2source.SimpleLogger;
import com.vaadin.source2source.api.ChangeHistory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stats {
    private static final String DIGIT_REGEX = "[^\\d]";
    private int totalVisitsByRules;
    private int totalChanges;
    private int totalAppliedRulesWithoutChanges;
    private final Map<String, Integer> totalAppliedRulesWithChangesPerRule = new HashMap<String, Integer>();
    private final Map<String, Integer> totalAppliedRulesWithoutChangesPerRule = new HashMap<String, Integer>();

    public int getTotalVisitsByRules() {
        return this.totalVisitsByRules;
    }

    public int getTotalChanges() {
        return this.totalChanges;
    }

    public int getTotalAppliedRulesWithoutChanges() {
        return this.totalAppliedRulesWithoutChanges;
    }

    public int getNumberOfMethodInvocations() {
        return this.totalAppliedRulesWithChangesPerRule.entrySet().stream().filter(e -> ((String)e.getKey()).contains("-MI")).map(Map.Entry::getValue).reduce(Integer::sum).orElse(0);
    }

    public void update(String fullClassName, List<ChangeHistory> changes) {
        if (changes.isEmpty()) {
            return;
        }
        this.totalVisitsByRules += changes.size();
        long unchanged = changes.stream().filter(change -> !change.isCodeChanged()).count();
        this.totalAppliedRulesWithoutChanges = (int)((long)this.totalAppliedRulesWithoutChanges + unchanged);
        this.totalChanges = (int)((long)this.totalChanges + ((long)changes.size() - unchanged));
        changes.stream().forEach(change -> {
            if ("Unchanged".equals(change.getDescription())) {
                int num = this.totalAppliedRulesWithoutChangesPerRule.getOrDefault(change.getAppliedFullRuleCode(), 0) + 1;
                this.totalAppliedRulesWithoutChangesPerRule.put(change.getAppliedFullRuleCode(), num);
            } else {
                int num = this.totalAppliedRulesWithChangesPerRule.getOrDefault(change.getAppliedFullRuleCode(), 0) + 1;
                this.totalAppliedRulesWithChangesPerRule.put(change.getAppliedFullRuleCode(), num);
            }
        });
    }

    public void writeStats(SimpleLogger reporter) {
        reporter.log("");
        reporter.log("");
        reporter.log(String.format("Total number of times rules were invoked: %s", this.getTotalVisitsByRules()));
        reporter.log(String.format("Number of changes in total: %s", this.getTotalChanges()));
        reporter.log(String.format("Number of changed method invocations: %s", this.getNumberOfMethodInvocations()));
        Comparator<Map.Entry<String, Integer>> comparator = this.getComparator();
        if (this.getTotalChanges() > 0) {
            reporter.log("Listing number of changes per rule:");
            this.totalAppliedRulesWithChangesPerRule.entrySet().stream().sorted(comparator).forEach(entry -> reporter.log(String.format("%s: %s", entry.getKey(), entry.getValue())));
        }
        if (this.getTotalAppliedRulesWithoutChanges() > 0) {
            reporter.log("");
            reporter.log(String.format("Number of times rules were invoked without any changes: %s", this.getTotalAppliedRulesWithoutChanges()));
            reporter.log("Listing invokes without any changes per rule:");
            this.totalAppliedRulesWithoutChangesPerRule.entrySet().stream().sorted(comparator).forEach(entry -> reporter.log(String.format("%s: %s", entry.getKey(), entry.getValue())));
        }
    }

    public Comparator<Map.Entry<String, Integer>> getComparator() {
        Comparator comparator = (a, b) -> {
            String groupA = ((String)a.getKey()).contains("-") ? ((String)a.getKey()).substring(0, ((String)a.getKey()).indexOf("-")) : (String)a.getKey();
            String groupB = ((String)b.getKey()).contains("-") ? ((String)b.getKey()).substring(0, ((String)b.getKey()).indexOf("-")) : (String)b.getKey();
            groupA = groupA.replaceAll(DIGIT_REGEX, "");
            groupB = groupB.replaceAll(DIGIT_REGEX, "");
            int result = Long.valueOf(groupA).compareTo(Long.valueOf(groupB));
            if (result == 0) {
                String keyA = ((String)a.getKey()).contains("-") ? ((String)a.getKey()).substring(((String)a.getKey()).indexOf("-") + 1) : (String)a.getKey();
                String keyB = ((String)b.getKey()).contains("-") ? ((String)b.getKey()).substring(((String)b.getKey()).indexOf("-") + 1) : (String)b.getKey();
                String keyANumber = keyA.replaceAll(DIGIT_REGEX, "");
                String keyBNumber = keyB.replaceAll(DIGIT_REGEX, "");
                if (keyANumber.isEmpty()) {
                    keyANumber = "1";
                }
                if (keyBNumber.isEmpty()) {
                    keyBNumber = "1";
                }
                try {
                    return Long.valueOf(keyANumber).compareTo(Long.valueOf(keyBNumber));
                }
                catch (Exception e) {
                    return result;
                }
            }
            return result;
        };
        return comparator;
    }
}

