/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class SimpleLogger {
    private final String dateSpacer = "    ";
    Writer llWriter = null;
    private boolean withDate;

    public SimpleLogger(String filePath, boolean withDate) {
        this.withDate = withDate;
        try {
            File llFile = new File(filePath);
            this.llWriter = new BufferedWriter(new FileWriter(llFile));
            this.llWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getDateTime() {
        if (this.withDate) {
            String datetime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
            return datetime + "    ";
        }
        return "";
    }

    public void log(String s) {
        try {
            this.llWriter.write(this.getDateTime() + s + "\n");
            this.llWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void error(String s, Throwable t) {
        try {
            this.llWriter.write("ERROR " + this.getDateTime() + s + "\n");
            t.printStackTrace(new PrintWriter(this.llWriter));
            this.llWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warning(String s) {
        try {
            this.llWriter.write("WARNING " + this.getDateTime() + s + "\n");
            this.llWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.llWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String howLong(long starttime) {
        long durationInMs = System.currentTimeMillis() - starttime;
        if (durationInMs < 1000L) {
            return durationInMs + "ms";
        }
        long seconds = durationInMs / 1000L;
        long ms = durationInMs % 1000L;
        return seconds + "s " + ms + "ms";
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

