/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source;

import com.vaadin.source2source.PluginProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;

public class ResourceHelper {
    private static Map<String, String> commentsCache = new HashMap<String, String>();
    private static Set<String> enabledRules = new HashSet<String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getEnabledRules() {
        if (!enabledRules.isEmpty()) {
            return enabledRules;
        }
        String currentUsersHomeDir = PluginProperties.get(PluginProperties.HOME_FOLDER);
        if (currentUsersHomeDir == null) return null;
        if (currentUsersHomeDir.isBlank()) {
            return null;
        }
        Path path = Paths.get(currentUsersHomeDir, "dragonfly", "config", "rules.csv");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        HashSet<String> enabled = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(path.toFile()));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                String parsedLine = ResourceHelper.parseLine(line);
                if (parsedLine == null) continue;
                String[] cells = line.split(";");
                String fullRuleCode = cells[0].trim();
                if ("*".equals(fullRuleCode) || "*.*".equals(fullRuleCode)) {
                    Set<String> set = null;
                    return set;
                }
                if (fullRuleCode.contains(".")) {
                    String group = fullRuleCode.substring(0, fullRuleCode.indexOf("."));
                    String rule = fullRuleCode.substring(fullRuleCode.indexOf(".") + 1);
                    if ("*".equals(rule)) {
                        enabled.add(group);
                        continue;
                    }
                    enabled.add(fullRuleCode);
                    continue;
                }
                enabled.add(fullRuleCode);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        enabledRules = enabled;
        return enabled;
    }

    public static Map<String, String> getRuleComments() {
        if (!commentsCache.isEmpty()) {
            return commentsCache;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String currentUsersHomeDir = PluginProperties.get(PluginProperties.HOME_FOLDER);
        if (currentUsersHomeDir == null || currentUsersHomeDir.isBlank()) {
            return result;
        }
        Path path = Paths.get(currentUsersHomeDir, "dragonfly", "config", "comments.csv");
        if (!Files.exists(path, new LinkOption[0])) {
            return result;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(path.toFile()));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                String parsedLine = ResourceHelper.parseLine(line);
                if (parsedLine == null) continue;
                String[] cells = line.split(";");
                String fullRuleCode = cells[0].trim();
                String comment = cells[1].trim();
                if (fullRuleCode.isBlank()) continue;
                result.put(fullRuleCode, comment);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        commentsCache = result;
        return result;
    }

    private static String parseLine(String line) {
        String trimmedLine = line.trim();
        if (!trimmedLine.isBlank() && !trimmedLine.startsWith("#")) {
            return trimmedLine;
        }
        return null;
    }

    public static String getAbsolutePathFor(String filename, String fileType) {
        try {
            if (fileType == null) {
                fileType = "log";
            }
            String workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            String userHome = PluginProperties.get(PluginProperties.HOME_FOLDER);
            Object targetFolder = PluginProperties.get(PluginProperties.VAADIN_REPORT_TARGET_FOLDER);
            if (targetFolder == null || ((String)targetFolder).isBlank()) {
                targetFolder = userHome + File.separatorChar + "report";
            } else {
                targetFolder = ((String)targetFolder).replace("${user.home}", userHome);
                targetFolder = ((String)targetFolder).replace("${workspace.root}", workspaceRoot);
            }
            Path path = Paths.get((String)targetFolder, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMddyyHHmmss"));
            return path.toFile().getAbsolutePath() + File.separator + filename + "-" + timestamp + "." + fileType;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

