/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PluginProperties {
    public static String AST_JLS_VERSION = "ast.jls.version";
    public static String JAVA_CORE_VERSION = "java.core.version";
    public static String JAVA_SOURCE_ENCODING = "java.source.encoding";
    public static String UTILITY_CLASS = "utility.class";
    public static String EXCLUDED_PACKAGES = "excluded.packages";
    public static String EXCLUDED_CLASSES = "excluded.classes";
    public static String HOME_FOLDER = "user.home";
    public static String VAADIN_REMOVE_IMPORTS = "vaadin.remove-imports";
    public static String VAADIN_REMOVE_IMPORTS_EXCEPTIONS = "vaadin.remove-imports-exceptions";
    public static String VAADIN_REMOVE_IMPORTS_WILDCARD = "vaadin.remove-imports-wildcard";
    public static String VAADIN_REPORT_TARGET_FOLDER = "vaadin.report-target-folder";
    public static String VAADIN_FQN_SIMPLIFICATION_ENABLED = "vaadin.fqn-simplification-enabled";
    private static Properties properties;

    public static Properties defaultProperties(Map<String, String> defaultProperties) {
        Properties prop = new Properties();
        prop.setProperty(AST_JLS_VERSION, "17");
        prop.setProperty(JAVA_CORE_VERSION, "11");
        prop.setProperty(JAVA_SOURCE_ENCODING, "UTF-8");
        prop.setProperty(UTILITY_CLASS, "com.vaadin.featurepack.util.V8Utils");
        prop.setProperty(EXCLUDED_PACKAGES, "com.vaadin.modernization.util,com.vaadin.modernization.component");
        prop.setProperty(VAADIN_REMOVE_IMPORTS, "com.vaadin, java.awt, javax.swing");
        prop.setProperty(VAADIN_REMOVE_IMPORTS_EXCEPTIONS, "spring,mosquito");
        prop.setProperty(VAADIN_REMOVE_IMPORTS_WILDCARD, "true");
        prop.setProperty(VAADIN_FQN_SIMPLIFICATION_ENABLED, "true");
        prop.setProperty(HOME_FOLDER, System.getProperty("user.home"));
        if (defaultProperties != null) {
            defaultProperties.entrySet().forEach(entry -> prop.setProperty((String)entry.getKey(), (String)entry.getValue()));
        }
        return prop;
    }

    public static String get(String key) {
        return properties.getProperty(key);
    }

    public static void set(String key, String value) {
        properties.setProperty(key, value);
    }

    public static Set<String> getSet(String key) {
        String value = PluginProperties.get(key);
        if (value == null || value.trim().isBlank()) {
            return Collections.emptySet();
        }
        return Stream.of(value.split(",")).filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet());
    }

    public static void setProperties(Properties prop) {
        properties = prop;
    }

    public static int getInt(String key) {
        return Integer.parseInt(PluginProperties.get(key));
    }
}

