/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.source2source;

import com.vaadin.source2source.ResourceHelper;
import com.vaadin.source2source.api.ChangeHistory;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class CsvReporter
implements Closeable {
    private final Writer writer;
    private boolean closed = false;

    public CsvReporter(OutputStream destination) throws IOException {
        this.writer = new OutputStreamWriter(destination);
        this.writer.write("TIMESTAMP;PRIMARY TYPE;LINE NUMBER;VAADIN CLASS;FULL RULE ID;DESCRIPTION;METHOD SIGNATURE;EXPECTED OUTCOME\n");
    }

    public static CsvReporter createDefaultCsvReporter() throws IOException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        if (projects.length == 0) {
            return null;
        }
        String path = ResourceHelper.getAbsolutePathFor("csvreport", "csv");
        FileOutputStream fileOutputStream = new FileOutputStream(path);
        return new CsvReporter(fileOutputStream);
    }

    public void write(String primaryTypeFullName, List<ChangeHistory> changes) throws IOException {
        Objects.requireNonNull(primaryTypeFullName);
        Objects.requireNonNull(changes);
        if (changes.isEmpty()) {
            return;
        }
        for (ChangeHistory change : changes) {
            String line = String.format("%s;\"%s\";%d;\"%s\";%s;\"%s\";\"%s\";\"%s\"\n", change.getTimestamp().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), primaryTypeFullName, change.getLineNumber(), change.getDeclaringClass(), change.getAppliedFullRuleCode(), change.getDescription(), Objects.toString(change.getMethodSignature(), ""), change.getExpectedOutcome());
            this.writer.write(line);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

