/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.dragonfly.mavenplugin;

import com.vaadin.modernization.dragonfly.mavenplugin.ByteArrayJarClassLoader;
import com.vaadin.modernization.dragonfly.mavenplugin.DragonflyMojo;
import com.vaadin.source2source.api.RemoteDragonflyExecutor;
import com.vaadin.source2source.api.RemoteFQNSimplify;
import com.vaadin.source2source.api.RemoteServiceUtil;
import com.vaadin.source2source.api.RemoteVisitorRegistryHelper;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class RemoteServiceMaven {
    private static ClassLoader dragonflyCore;
    private static Log logger;

    public static void init(Log l, String localVersionString) throws MojoExecutionException {
        logger = l;
        String versionCheck = RemoteServiceUtil.checkVersion(localVersionString);
        if (versionCheck == null) {
            try {
                InputStream jarInputStream = RemoteServiceUtil.getJarInputStream();
                dragonflyCore = new ByteArrayJarClassLoader(jarInputStream.readAllBytes(), DragonflyMojo.class.getClassLoader());
            }
            catch (Exception e) {
                String msg = "Can not download data from https://cdn.vaadin.com";
                logger.error((CharSequence)msg);
                throw new MojoExecutionException(msg, e);
            }
        } else if (versionCheck.equals("local")) {
            try {
                dragonflyCore = new URLClassLoader(new URL[]{new URL(RemoteServiceUtil.getDragonflyCorePath())}, DragonflyMojo.class.getClassLoader());
            }
            catch (Exception e) {
                String msg = "Can not load data from local path: " + RemoteServiceUtil.getDragonflyCorePath();
                logger.error((CharSequence)msg);
                throw new MojoExecutionException(msg);
            }
        } else {
            String msg = "Version error : " + versionCheck;
            logger.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
    }

    public static RemoteDragonflyExecutor getDragonflyExecutor() {
        try {
            Class<?> clazz = dragonflyCore.loadClass("com.vaadin.source2source.core.DragonflyExecutor");
            RemoteDragonflyExecutor remoteExecutor = (RemoteDragonflyExecutor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return remoteExecutor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RemoteFQNSimplify getFQNSimplify() {
        try {
            Class<?> clazz = dragonflyCore.loadClass("com.vaadin.dragonfly.fqnsimplifier.FQNSimplify");
            RemoteFQNSimplify fqnSimplfy = (RemoteFQNSimplify)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return fqnSimplfy;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RemoteVisitorRegistryHelper getVisitorRegistryHelper() {
        try {
            Class<?> clazz = dragonflyCore.loadClass("com.vaadin.source2source.core.VisitorRegistryHelper");
            RemoteVisitorRegistryHelper registryHelper = (RemoteVisitorRegistryHelper)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return registryHelper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

