/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.dragonfly.mavenplugin;

import com.vaadin.modernization.dragonfly.mavenplugin.RemoteServiceMaven;
import com.vaadin.source2source.CsvReporter;
import com.vaadin.source2source.PluginProperties;
import com.vaadin.source2source.SimpleLogger;
import com.vaadin.source2source.Stats;
import com.vaadin.source2source.api.RemoteDragonflyExecutor;
import com.vaadin.source2source.api.RemoteFQNSimplify;
import com.vaadin.source2source.api.Visitors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;

@Mojo(name="dragonfly", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class DragonflyMojo
extends AbstractMojo {
    private static final String V23_TARGET = "modernization.target.v23";
    @Parameter(property="excludedClasses", required=false)
    private Set<String> excludedClasses;
    @Parameter(property="excludedPackages", required=false)
    private Set<String> excludedPackages;
    @Parameter(property="includedSources", required=false)
    private Set<String> includedSources;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="sourceEncoding", readonly=true, defaultValue="UTF-8", required=false)
    private String sourceEncoding;
    @Parameter(property="simplifyFQN", readonly=true, defaultValue="true", required=false)
    private boolean simplifyFQN;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true, required=true)
    private List<String> testCompilePath;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", readonly=true, required=true)
    private List<String> testCompileSourceRoots;
    @Parameter(property="modernization.target.v23", readonly=true, defaultValue="false", required=false)
    private String v23Target;

    public void execute() throws MojoExecutionException {
        this.dragonfly(this.project.getBasedir(), this.mojo.getPlugin().getVersion(), this.compileSourceRoots, this.testCompileSourceRoots, this.compilePath, this.testCompilePath, this.includedSources, this.sourceEncoding, this.excludedClasses, this.excludedPackages, this.simplifyFQN);
    }

    public void dragonfly(File baseDir, String pluginVersion, List<String> compileSourceRoots, List<String> testCompileSourceRoots, List<String> compilePath, List<String> testCompilePath, Set<String> includedSources, String sourceEncoding, Set<String> excludedClasses, Set<String> excludedPackages, boolean simplifyFQN) throws MojoExecutionException {
        RemoteServiceMaven.init(this.getLog(), pluginVersion);
        Properties props = PluginProperties.defaultProperties(null);
        if (this.v23Target != null) {
            System.setProperty(V23_TARGET, this.v23Target);
        }
        PluginProperties.setProperties(props);
        Visitors visitors = RemoteServiceMaven.getVisitorRegistryHelper().getVaadin8ToVaadinRegistry().getVisitors();
        CsvReporter csvReporter = this.setupCsvReporter(baseDir);
        if (csvReporter == null) {
            this.getLog().error((CharSequence)"Can not create CSV Reporter.");
            return;
        }
        Stats stats = new Stats();
        SimpleLogger reporter = this.setupChangeReport(baseDir);
        SimpleLogger logger = this.setupLogger(baseDir);
        compileSourceRoots.addAll(testCompileSourceRoots);
        compilePath = this.buildCompilePath(compilePath, testCompilePath);
        String[] sourceFilePaths = !includedSources.isEmpty() ? includedSources.toArray(new String[0]) : this.getSourceFilePaths(compileSourceRoots);
        int lap = 1;
        for (List<ASTVisitor> visitorsList : visitors.getAll()) {
            if (!visitorsList.isEmpty()) {
                try {
                    RemoteDragonflyExecutor dragonflyExecutor = RemoteServiceMaven.getDragonflyExecutor();
                    dragonflyExecutor.executeTransformation(this.createParser(compileSourceRoots, compilePath), sourceEncoding, sourceFilePaths, visitorsList, excludedClasses, excludedPackages, logger, stats, reporter, csvReporter, lap, false);
                }
                catch (IllegalArgumentException e) {
                    this.getLog().error((CharSequence)("Error occured while creating environment: " + e.getMessage()));
                    this.getLog().error((CharSequence)"Before running Dragonfly, make sure the project(s) compile successfully. ( E.g.: Try mvn clean install )");
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ++lap;
        }
        if (simplifyFQN) {
            RemoteFQNSimplify fqnSimplfy = RemoteServiceMaven.getFQNSimplify();
            fqnSimplfy.simplfy(sourceEncoding, reporter, sourceFilePaths);
        }
        stats.writeStats(reporter);
        reporter.close();
        try {
            csvReporter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().warn((CharSequence)"Exception in closing CSV Reporter.");
            this.getLog().error((CharSequence)e.getMessage());
            return;
        }
    }

    private String getAbsolutePath(File baseDir, String filename, String fileType) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMddyyHHmmss"));
        return baseDir.getAbsolutePath() + File.separator + filename + "-" + timestamp + "." + fileType;
    }

    private SimpleLogger setupLogger(File baseDir) {
        return new SimpleLogger(this.getAbsolutePath(baseDir, "log", "log"), true);
    }

    private SimpleLogger setupChangeReport(File baseDir) {
        return new SimpleLogger(this.getAbsolutePath(baseDir, "changereport", "log"), false);
    }

    private CsvReporter setupCsvReporter(File baseDir) {
        try {
            String path = this.getAbsolutePath(baseDir, "csvreport", "csv");
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            return new CsvReporter(fileOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] getSourceFilePaths(List<String> compileSourceRoots) {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (String sourceRoot : compileSourceRoots) {
            try {
                if (!Files.exists(Path.of(sourceRoot, new String[0]), new LinkOption[0])) continue;
                sourceFiles.addAll(this.loadSourceFiles(sourceRoot));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Can not get source files from " + sourceRoot));
                return null;
            }
        }
        return sourceFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()).toArray(new String[0]);
    }

    private ASTParser createParser(List<String> compileSourceRoots, List<String> compilePath) {
        compileSourceRoots = compileSourceRoots.stream().filter(p -> Files.exists(Path.of(p, new String[0]), new LinkOption[0])).collect(Collectors.toList());
        String[] sources = compileSourceRoots.toArray(new String[0]);
        String[] classpath = compilePath.toArray(new String[0]);
        classpath = Stream.of(classpath).filter(path -> {
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.getLog().warn((CharSequence)("Removing non-existing path from classpath:" + path));
                return false;
            }
            return true;
        }).collect(Collectors.toList()).toArray(new String[0]);
        ASTParser parser = ASTParser.newParser((int)11);
        parser.setResolveBindings(true);
        parser.setKind(8);
        parser.setBindingsRecovery(false);
        parser.setCompilerOptions(this.getCompilerOptions());
        parser.setEnvironment(classpath, sources, Collections.nCopies(sources.length, this.sourceEncoding).toArray(new String[0]), true);
        return parser;
    }

    private Hashtable<String, String> getCompilerOptions() {
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        return options;
    }

    private List<File> loadSourceFiles(String packageRootPath) throws IOException {
        try (Stream<Path> stream = Files.walk(Path.of(packageRootPath, new String[0]), new FileVisitOption[0]);){
            List<File> list = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).filter(path -> !path.getFileName().toString().equals("package-info.java")).filter(path -> !path.getFileName().toString().equals("module-info.java")).map(path -> path.toFile()).collect(Collectors.toList());
            return list;
        }
    }

    private List<String> buildCompilePath(List<String> compilePaths, List<String> testCompilePaths) {
        HashSet<String> path = new HashSet<String>();
        path.addAll(compilePaths);
        path.addAll(testCompilePaths);
        return path.stream().collect(Collectors.toList());
    }
}

