/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.modernization.dragonfly.mavenplugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ByteArrayJarClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classBytes = new HashMap<String, byte[]>();
    private final Map<String, byte[]> resourceBytes = new HashMap<String, byte[]>();

    public ByteArrayJarClassLoader(byte[] jarBytes, ClassLoader parent) throws IOException {
        super(parent);
        this.loadJar(jarBytes);
    }

    private void loadJar(byte[] jarBytes) throws IOException {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(jarBytes);
             JarInputStream jarStream = new JarInputStream(byteStream);){
            JarEntry entry;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                if (entry.getName().endsWith(".class") && !entry.isDirectory()) {
                    String className = entry.getName().replace("/", ".");
                    if (className.endsWith(".class")) {
                        className = className.substring(0, className.length() - 6);
                    }
                    this.classBytes.put(className, jarStream.readAllBytes());
                    continue;
                }
                if (entry.getName().endsWith(".jar") || entry.isDirectory()) continue;
                this.resourceBytes.put(entry.getName(), jarStream.readAllBytes());
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.resourceBytes.containsKey(name)) {
            return new ByteArrayInputStream(this.resourceBytes.get(name));
        }
        return super.getResourceAsStream(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classData = this.classBytes.get(name);
        if (classData == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, classData, 0, classData.length);
    }
}

