/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.googlemaps.GoogleMapIcon;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.MarkerLabel;
import com.flowingcode.vaadin.jsonmigration.JsonMigration;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;

@Tag(value="google-map-marker")
@JsModule(value="@flowingcode/google-map/google-map-marker.js")
@NpmPackage.Container(value={@NpmPackage(value="@flowingcode/google-map", version="3.9.0"), @NpmPackage(value="@googlemaps/markerclusterer", version="2.0.8")})
public class GoogleMapMarker
extends Component {
    private static long idCounter = 0L;
    private long id = idCounter++;
    private boolean animationEnabled = true;

    public GoogleMapMarker() {
        this.getElement().setAttribute("slot", "markers");
    }

    public GoogleMapMarker(String caption, LatLon position, boolean draggable) {
        this();
        this.setCaption(caption);
        this.setPosition(position);
        this.setDraggable(draggable);
    }

    public GoogleMapMarker(String caption, LatLon position, boolean draggable, String iconUrl) {
        this(caption, position, draggable);
        this.setIconUrl(iconUrl);
    }

    public GoogleMapMarker(String caption, LatLon position, boolean draggable, GoogleMapIcon icon) {
        this(caption, position, draggable);
        this.setIcon(icon);
    }

    public void addInfoWindow(String htmlContent) {
        this.getElement().setProperty("innerHTML", htmlContent);
    }

    @Synchronize(value={"google-map-marker-open", "google-map-marker-close"}, property="open")
    public boolean isInfoWindowVisible() {
        return this.getElement().getProperty("open", false);
    }

    public void setInfoWindowVisible(boolean visible) {
        this.getElement().setProperty("open", visible);
    }

    public LatLon getPosition() {
        LatLon latLon = new LatLon();
        latLon.setLat(this.getElement().getProperty("latitude", 0.0));
        latLon.setLon(this.getElement().getProperty("longitude", 0.0));
        return latLon;
    }

    public void setPosition(LatLon position) {
        this.getElement().setProperty("latitude", position.getLat());
        this.getElement().setProperty("longitude", position.getLon());
    }

    public String getCaption() {
        return this.getElement().getProperty("title");
    }

    public void setCaption(String caption) {
        this.getElement().setProperty("title", caption != null ? caption : "");
    }

    public boolean isDraggable() {
        return this.getElement().getProperty("draggable", false);
    }

    public void setDraggable(boolean draggable) {
        this.getElement().setProperty("draggable", draggable);
    }

    public String getIconUrl() {
        return this.getElement().getProperty("icon");
    }

    public void setIconUrl(String iconUrl) {
        this.getElement().setProperty("icon", iconUrl);
    }

    public void setIcon(GoogleMapIcon icon) {
        JsonMigration.setPropertyJson((Element)this.getElement(), (String)"icon", (JsonValue)icon.getJson());
    }

    public void setLabel(MarkerLabel label) {
        JsonMigration.setPropertyJson((Element)this.getElement(), (String)"label", (JsonValue)label.getJson());
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public boolean isOptimized() {
        return this.getElement().getProperty("optimized", false);
    }

    public void setOptimized(boolean optimized) {
        this.getElement().setProperty("optimized", optimized);
    }

    public long getIdentifier() {
        return this.id;
    }

    public void setIdentifier(long id) {
        this.id = id;
    }

    public Registration addDragEndEventListener(ComponentEventListener<DragEndEvent> listener) {
        this.getElement().setProperty("dragEvents", true);
        return this.addListener(DragEndEvent.class, listener);
    }

    public Registration addClickListener(ComponentEventListener<GoogleMapMarkerClickEvent> listener) {
        this.getElement().setProperty("clickable", true);
        this.getElement().setProperty("clickEvents", true);
        return this.addListener(GoogleMapMarkerClickEvent.class, listener);
    }

    public Registration addRightClickListener(ComponentEventListener<GoogleMapMarkerRightClickEvent> listener) {
        this.getElement().setProperty("clickable", true);
        this.getElement().setProperty("clickEvents", true);
        return this.addListener(GoogleMapMarkerRightClickEvent.class, listener);
    }

    @DomEvent(value="google-map-marker-dragend")
    public static class DragEndEvent
    extends ComponentEvent<GoogleMapMarker> {
        private final double lat;
        private final double lon;

        public DragEndEvent(GoogleMapMarker source, boolean fromClient, @EventData(value="event.detail.latLng") JsonValue latLng) {
            super((Component)source, fromClient);
            this.lat = ((JsonObject)latLng).getNumber("lat");
            this.lon = ((JsonObject)latLng).getNumber("lng");
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }
    }

    @DomEvent(value="google-map-marker-click")
    public static class GoogleMapMarkerClickEvent
    extends ClickEvent<GoogleMapMarker> {
        private final double lat;
        private final double lon;

        public GoogleMapMarkerClickEvent(GoogleMapMarker source, boolean fromClient, @EventData(value="event.detail.latLng") JsonValue latLng) {
            super((Component)source);
            this.lat = ((JsonObject)latLng).getNumber("lat");
            this.lon = ((JsonObject)latLng).getNumber("lng");
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }
    }

    @DomEvent(value="google-map-marker-rightclick")
    public static class GoogleMapMarkerRightClickEvent
    extends ClickEvent<GoogleMapMarker> {
        private final double lat;
        private final double lon;

        public GoogleMapMarkerRightClickEvent(GoogleMapMarker source, boolean fromClient, @EventData(value="event.detail.domEvent.screenX") int screenX, @EventData(value="event.detail.domEvent.screenY") int screenY, @EventData(value="event.detail.domEvent.clientX") int clientX, @EventData(value="event.detail.domEvent.clientY") int clientY, @EventData(value="event.detail.domEvent.detail") int clickCount, @EventData(value="event.detail.domEvent.button") int button, @EventData(value="event.detail.domEvent.ctrlKey") boolean ctrlKey, @EventData(value="event.detail.domEvent.shiftKey") boolean shiftKey, @EventData(value="event.detail.domEvent.altKey") boolean altKey, @EventData(value="event.detail.domEvent.metaKey") boolean metaKey, @EventData(value="event.detail.latLng") JsonValue latLng) {
            super((Component)source, fromClient, screenX, screenY, clientX, clientY, clickCount, button, ctrlKey, shiftKey, altKey, metaKey);
            this.lat = ((JsonObject)latLng).getNumber("lat");
            this.lon = ((JsonObject)latLng).getNumber("lng");
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }
    }
}

