/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.googlemaps.GoogleMapIcon;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPoint;
import com.flowingcode.vaadin.addons.googlemaps.util.JsonIconUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class Symbol
implements GoogleMapIcon {
    @NonNull
    private String path;
    private GoogleMapPoint anchor;
    private GoogleMapPoint labelOrigin;
    private String fillColor;
    private Double fillOpacity;
    private Double rotation;
    private Double scale;
    private String strokeColor;
    private Double strokeOpacity;
    private Double strokeWeight;

    public Symbol(String path, String strokeColor, String fillColor, Double fillOpacity) {
        this(path);
        this.strokeColor = strokeColor;
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
    }

    @Override
    public JsonObject getJson() {
        JsonObject js = Json.createObject();
        js.put("path", this.path);
        Optional.ofNullable(this.getAnchor()).ifPresent(value -> js.put("anchor", (JsonValue)JsonIconUtils.getPointJson(value)));
        Optional.ofNullable(this.getLabelOrigin()).ifPresent(value -> js.put("labelOrigin", (JsonValue)JsonIconUtils.getPointJson(value)));
        Optional.ofNullable(this.getFillColor()).ifPresent(value -> js.put("fillColor", value));
        Optional.ofNullable(this.getFillOpacity()).ifPresent(value -> js.put("fillOpacity", value.doubleValue()));
        Optional.ofNullable(this.getRotation()).ifPresent(value -> js.put("rotation", value.doubleValue()));
        Optional.ofNullable(this.getScale()).ifPresent(value -> js.put("scale", value.doubleValue()));
        Optional.ofNullable(this.getStrokeColor()).ifPresent(value -> js.put("strokeColor", value));
        Optional.ofNullable(this.getStrokeOpacity()).ifPresent(value -> js.put("strokeOpacity", value.doubleValue()));
        Optional.ofNullable(this.getStrokeWeight()).ifPresent(value -> js.put("strokeWeight", value.doubleValue()));
        return js;
    }

    @NonNull
    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public GoogleMapPoint getAnchor() {
        return this.anchor;
    }

    @Generated
    public GoogleMapPoint getLabelOrigin() {
        return this.labelOrigin;
    }

    @Generated
    public String getFillColor() {
        return this.fillColor;
    }

    @Generated
    public Double getFillOpacity() {
        return this.fillOpacity;
    }

    @Generated
    public Double getRotation() {
        return this.rotation;
    }

    @Generated
    public Double getScale() {
        return this.scale;
    }

    @Generated
    public String getStrokeColor() {
        return this.strokeColor;
    }

    @Generated
    public Double getStrokeOpacity() {
        return this.strokeOpacity;
    }

    @Generated
    public Double getStrokeWeight() {
        return this.strokeWeight;
    }

    @Generated
    public void setPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }

    @Generated
    public void setAnchor(GoogleMapPoint anchor) {
        this.anchor = anchor;
    }

    @Generated
    public void setLabelOrigin(GoogleMapPoint labelOrigin) {
        this.labelOrigin = labelOrigin;
    }

    @Generated
    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    @Generated
    public void setFillOpacity(Double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    @Generated
    public void setRotation(Double rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setScale(Double scale) {
        this.scale = scale;
    }

    @Generated
    public void setStrokeColor(String strokeColor) {
        this.strokeColor = strokeColor;
    }

    @Generated
    public void setStrokeOpacity(Double strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
    }

    @Generated
    public void setStrokeWeight(Double strokeWeight) {
        this.strokeWeight = strokeWeight;
    }

    @Generated
    public Symbol(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }
}

