/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.googlemaps.Symbol;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import lombok.Generated;

public class IconSequence {
    private Symbol symbol;
    private String repeat;
    private boolean fixedRotation;
    private String offset;

    public IconSequence(Symbol symbol) {
        this.symbol = symbol;
    }

    public IconSequence(Symbol symbol, String repeat) {
        this(symbol);
        this.repeat = repeat;
    }

    protected JsonObject getJson() {
        JsonObject js = Json.createObject();
        JsonObject symbolJs = this.symbol.getJson();
        js.put("icon", (JsonValue)symbolJs);
        Optional.ofNullable(this.getRepeat()).ifPresent(value -> js.put("repeat", value));
        Optional.ofNullable(this.isFixedRotation()).ifPresent(value -> js.put("fixedRotation", value.booleanValue()));
        Optional.ofNullable(this.getOffset()).ifPresent(value -> js.put("offset", value));
        return js;
    }

    @Generated
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Generated
    public String getRepeat() {
        return this.repeat;
    }

    @Generated
    public boolean isFixedRotation() {
        return this.fixedRotation;
    }

    @Generated
    public String getOffset() {
        return this.offset;
    }

    @Generated
    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    @Generated
    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    @Generated
    public void setFixedRotation(boolean fixedRotation) {
        this.fixedRotation = fixedRotation;
    }

    @Generated
    public void setOffset(String offset) {
        this.offset = offset;
    }
}

