/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm;

import com.flowingcode.vaadin.addons.xterm.TerminalAddon;
import com.flowingcode.vaadin.addons.xterm.XTermBase;
import com.flowingcode.vaadin.jsonmigration.JsonMigration;
import com.vaadin.flow.server.Version;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public abstract class ClientTerminalAddon
extends TerminalAddon {
    private final XTermBase xterm;
    private static final MethodHandle encodeWithTypeInfo = ClientTerminalAddon.lookup_encodeWithTypeInfo();

    protected ClientTerminalAddon(XTermBase xterm) {
        super(xterm);
        this.xterm = xterm;
        if (this.getName() == null) {
            throw new IllegalStateException("getName() must return a non-null value");
        }
    }

    protected XTermBase getXterm() {
        return this.xterm;
    }

    protected abstract String getName();

    protected final void executeJs(String expression, Serializable ... parameters) {
        String name = this.getName();
        JsonArray args = Json.createArray();
        for (int i = 0; i < parameters.length; ++i) {
            args.set(i, ClientTerminalAddon.encodeWithTypeInfo(parameters[i]));
        }
        expression = expression.replaceAll("\\$(\\d+)", "\\$1[$1]");
        this.xterm.executeJs("(function(){" + expression + "}).apply(this.addons[$0],$1);", new Serializable[]{name, args});
    }

    private static MethodHandle lookup_encodeWithTypeInfo() {
        MethodHandle handle;
        if (Version.getMajorVersion() > 24) {
            Class<?> result = Class.forName("tools.jackson.databind.JsonNode");
            Class<?> codec = Class.forName("com.vaadin.flow.internal.JacksonCodec");
            MethodType type = MethodType.methodType(result, Object.class);
            handle = MethodHandles.lookup().findStatic(codec, "encodeWithTypeInfo", type);
        } else {
            Class<?> codec = Class.forName("com.vaadin.flow.internal.JsonCodec");
            MethodType type = MethodType.methodType(JsonValue.class, Object.class);
            handle = MethodHandles.lookup().findStatic(codec, "encodeWithTypeInfo", type);
        }
        return handle.asType(MethodType.methodType(Object.class, Object.class));
    }

    private static JsonValue encodeWithTypeInfo(Object obj) {
        try {
            return JsonMigration.convertToJsonValue((Object)encodeWithTypeInfo.invokeExact(obj));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

