/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.applayout;

import com.flowingcode.addons.applayout.HasMenuItemCommands;
import com.flowingcode.addons.applayout.HasMenuItemIcon;
import com.flowingcode.addons.applayout.SlottedMenuItem;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.server.Command;
import java.util.function.Consumer;

@NpmPackage.Container(value={@NpmPackage(value="@polymer/iron-collapse", version="3.0.1"), @NpmPackage(value="@polymer/paper-item", version="3.0.1"), @NpmPackage(value="@flowingcode/fc-menuitem", version="1.0.0")})
@Tag(value="fc-menuitem")
@JsModule(value="@flowingcode/fc-menuitem/fc-menuitem.js")
public class MenuItem
extends SlottedMenuItem
implements HasOrderedComponents,
HasMenuItemCommands<MenuItem>,
HasMenuItemIcon<MenuItem> {
    static final String BLANK = "fc-menuitem-icons:empty";

    public MenuItem() {
    }

    public MenuItem(String label) {
        this.setLabel(label);
    }

    public MenuItem(String label, Command command) {
        this.setLabel(label);
        this.setCommand(command);
    }

    public MenuItem(String label, Class<? extends Component> navigationTarget) {
        this.setLink(new RouterLink(label, navigationTarget));
    }

    public MenuItem(String label, String icon) {
        this(label);
        this.setIcon(icon);
    }

    public MenuItem(String label, IconFactory icon) {
        this(label);
        this.setIcon(icon.create().getElement().getAttribute("icon"));
    }

    public MenuItem(String label, IconFactory icon, Command command) {
        this(label, icon);
        this.setCommand(command);
    }

    public MenuItem(String label, String icon, Command command) {
        this(label, icon);
        this.setCommand(command);
    }

    public final MenuItem add(MenuItem ... items) {
        this.add((Component[])items);
        return this;
    }

    public void add(Component ... components) {
        super.add(components);
    }

    public String getTitle() {
        return this.getElement().getAttribute("title");
    }

    public MenuItem setTitle(String title) {
        this.getElement().setAttribute("title", title);
        return this;
    }

    public String getLabel() {
        return this.getElement().getAttribute("label");
    }

    public String getHref() {
        return this.getElement().getProperty("href");
    }

    public MenuItem setLabel(String label) {
        this.getElement().setAttribute("label", label);
        return this;
    }

    public MenuItem setLink(RouterLink link) {
        this.setLabel(link.getText());
        this.setHref(link.getHref());
        return this;
    }

    public MenuItem setHref(String href) {
        this.getElement().setProperty("href", href);
        return this;
    }

    public MenuItem setOpened(boolean opened) {
        if (opened) {
            this.getElement().setAttribute("opened", opened);
        } else {
            this.getElement().removeAttribute("opened");
        }
        return this;
    }

    public MenuItem configure(Consumer<MenuItem> consumer) {
        consumer.accept(this);
        return this;
    }

    @Deprecated
    public void setIconSpacing(boolean value) {
        this.setIcon(BLANK);
    }

    public void setIconBlank() {
        this.setIcon(BLANK);
    }
}

